/*
 * Decompiled with CFR 0.152.
 */
package geometry.bounding;

import geometry.Geometry;
import java.util.Comparator;

public class GeoSorters {
    public static final Comparator<Geometry> x = new Comparator<Geometry>(){

        @Override
        public int compare(Geometry o1, Geometry o2) {
            if (o1.getMid().x < o2.getMid().x) {
                return -1;
            }
            if (o1.getMid().x > o2.getMid().x) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<Geometry> y = new Comparator<Geometry>(){

        @Override
        public int compare(Geometry o1, Geometry o2) {
            if (o1.getMid().y < o2.getMid().y) {
                return -1;
            }
            if (o1.getMid().y > o2.getMid().y) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<Geometry> z = new Comparator<Geometry>(){

        @Override
        public int compare(Geometry o1, Geometry o2) {
            if (o1.getMid().z < o2.getMid().z) {
                return -1;
            }
            if (o1.getMid().z > o2.getMid().z) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<Geometry> xSplit = new Comparator<Geometry>(){

        @Override
        public int compare(Geometry o1, Geometry o2) {
            if (o1.getMax().x < o2.getMid().x) {
                return -1;
            }
            if (o1.getMin().x > o2.getMid().x) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<Geometry> ySplit = new Comparator<Geometry>(){

        @Override
        public int compare(Geometry o1, Geometry o2) {
            if (o1.getMax().y < o2.getMin().y) {
                return -1;
            }
            if (o1.getMin().y > o2.getMax().y) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<Geometry> zSplit = new Comparator<Geometry>(){

        @Override
        public int compare(Geometry o1, Geometry o2) {
            if (o1.getMax().z < o2.getMin().z) {
                return -1;
            }
            if (o1.getMin().z > o2.getMax().z) {
                return 1;
            }
            return 0;
        }
    };

    public static Comparator<Geometry> getComparator(int depth) {
        switch (depth % 3) {
            case 0: {
                return x;
            }
            case 1: {
                return y;
            }
            case 2: {
                return z;
            }
        }
        throw new IllegalStateException();
    }

    public static Comparator<Geometry> getSplitter(int depth) {
        switch (depth % 3) {
            case 0: {
                return xSplit;
            }
            case 1: {
                return ySplit;
            }
            case 2: {
                return zSplit;
            }
        }
        throw new IllegalStateException();
    }
}

