/*
 * Decompiled with CFR 0.152.
 */
package geometry;

import algebra.Algebra;
import algebra.Vector3f;
import geometry.Geometry;
import geometry.Sphere;
import geometry.ray.Ray;
import geometry.ray.RayResult;

public class NegaSphere
extends Sphere {
    public NegaSphere(Vector3f m, float r) {
        super(m, r);
    }

    @Override
    public RayResult intersect(Ray ray) {
        double c;
        double a = Algebra.dot1(ray.d);
        double b = 2.0f * Algebra.dot(ray.d, Algebra.substract(ray.e, this.m));
        double discr = b * b - 4.0 * a * (c = (double)(Algebra.dot1(Algebra.substract(ray.e, this.m)) - this.r * this.r));
        if (discr < 0.0) {
            return null;
        }
        float q = (float)(-0.5 * (b - Math.signum(b) * Math.sqrt(discr)));
        float t = (float)(c / (double)q);
        if (t < 0.0f) {
            t = (float)((double)q / a);
        }
        if (t < 0.0f) {
            return null;
        }
        return new RayNegaSphereResult(ray, t, (Geometry)this);
    }

    public class RayNegaSphereResult
    extends Sphere.RaySphereResult {
        public RayNegaSphereResult(Ray ray, float t, Geometry hit) {
            super(ray, t, hit);
        }

        @Override
        public Vector3f calcNormal() {
            Vector3f n = Algebra.unit(Algebra.substract(NegaSphere.this.m, this.getObjectLocation()));
            return n;
        }
    }
}

