;welcome to my 4K "PSYCH 66" (last change 20.8.2008)
;
jmp f09
;
;
;
; cs:103 putpixel (set si=x;di=y;ax=mode(0-noclipping,1-cliping);cl=color;bx=image struct pointer)
; cs:124 getpixel (set si=x;di=y;bx=image struct pointer; get cl=color)
; cs:137 getsprite (set si=source image struc;di=sprite image struc;ax=x;bx=y)
; cs:173 putsprite (set si=source sprite struc;di=dist image struc;
;                       ax=x;bx=y;
;                       cx=mode(0-no clip/no mask,
;                               1-no clip/mask,
;                               2-clip/no mask,
;                               3-clip/mask);
;                       dl=mask color)
; cs:1e9 FlipScreen
; cs:20c fillimage (set dl=color di=image struct pointer)
; cs:22a write to pal (set al=numcol;ah=r;bl=g;bh=b)
; cs:24a random (get dl=random byte)
; cs:259 hLine (set ax=x1 bx=x2 cx=y dx=color di=image struct pointer)
; cs:273 vLine (set ax=x bx=y1 cx=y2 dx=color di=image struct pointer)
; cs:28e degtorad(set r=degree; get tb=rad)
; cs:2b7 scalesprite (set ax=xo,bx=yo,cx=tox,dx=toy;si=sprite,di=dist;
;                         es=mode(0-no clip/no mask,
;                                 1-no clip/mask,
;                                 2-clip/no mask,
;                                 3-clip/mask);
;                         bp=mask color)
; cs:3e4 rotateSprite (set ax=zdwigX, bx=zdwigY, cx=midX, dx=midY,
;                          si=sprite image, di=dist screen,
;                          tb=rotateAngle, bp=mask color)
;
;
;
;
;
;                   a000 struct   by cs:1100
;                Vscreen struct   by cs:1108
;                             w   by cs:1110
;                            ww   by cs:1112
;                             b   by cs:1114
;                            ch   by cs:1115
;                           col   by cs:1116
;                             i   by cs:1117
;                            bb   by cs:1119
;          a temp screen struct   by cs:111a
;                             x   by cs:1122
;                             y   by cs:1124
;                          col1   by cs:1126
;                          col2   by cs:1127
;                          col3   by cs:1128
;                          col4   by cs:1129
;                          col5   by cs:112a
;                          col6   by cs:112b
;                          col7   by cs:112c
;                          col8   by cs:112d
;                            i3   by cs:112e
;                           tb1   by cs:1130
;                           tb2   by cs:113a
;                            sy   by cs:1144
;                            sx   by cs:114e
;                            tb   by cs:1158
;                           tb3   by cs:1162
;                           tb4   by cs:116c
;                            xx   by cs:1176
;                            yy   by cs:1178
;                            x1   by cs:117a
;                            y1   by cs:117c
;                            ii   by cs:117e
;                           tb5   by cs:1180
;                           tb6   by cs:118a
;                           tb8   by cs:1194
;                           tb9   by cs:119e
;                          tb10   by cs:11a8
;                            x2   by cs:11b2
;                            y2   by cs:11b4
;                            x3   by cs:11b6
;                            y3   by cs:11b8
;                            x4   by cs:11ba
;                            y4   by cs:11bc
;                            x5   by cs:11be
;                            y5   by cs:11c0
;                            x7   by cs:11c2
;                            y7   by cs:11c4
;                            i1   by cs:11c6
;                            i2   by cs:11c8
;                          tb11   by cs:11ca
;                          tb12   by cs:11d4
;                            x6   by cs:11de
;                            y6   by cs:11e0
;                             r   by cs:11e2
;                           tb7   by cs:11ec
;               randomizer seed   by cs:11f6
;                          tb13   by cs:11f8
;                          tb14   by cs:1202
;                          tb15   by cs:120c
;                          tb16   by cs:1216
;           '"PSYCH 66"' sprite   by cs:1220
;       'Code: Key-Real' sprite   by cs:144c
;          'first smily' sprite   by cs:17d6
;         'second smily' sprite   by cs:1820
;          'raute sybol' sprite   by cs:186a
;            'big raute' sprite   by cs:18b4
;          'Hart symbol' sprite   by cs 1cbe
;            'big Smile' sprite   by cs:1ed6
;                   ':)' sprite   by cs:2ede
;
;
;
;
;
;
;*******************************
;
;
; Image Structure:
;                       0 word width
;                       2 word heigh
;                       4 word data segment
;                       6 word data offset
;
;
;
;
;
; cs:103 putpixel (set si=x;di=y;ax=mode(0-noclipping,1-cliping);cl=color;bx=image struct pointer)
cmp ax,0
jz 111 ;@noclip
cmp si,[bx]
jae 123 ;@return
cmp di,[bx+2]
jae 123 ;@return
;@nopclip 111
mov ax,[bx]
mul di
add si,ax
add si,[bx+6]
push ds
mov ax,[bx+4]
mov ds,ax
mov [si],cl
pop ds
;@return 123
ret
;
;
;
;
;
; cs:124 getpixel (set si=x;di=y;bx=image struct pointer; get cl=color)
;
mov ax,[bx]
mul di
add si,ax
add si,[bx+6]
push ds
mov ax,[bx+4]
mov ds,ax
mov cl,[si]
pop ds
RET
;
;
;
;
; cs:137 getsprite (set si=source image struc;di=sprite image struc;ax=x;bx=y)
push es
xor cx,cx
mov es,cx
;@yloop                 cs:13c
xor cx,cx
;@xloop                 cs:13e
;
db 60
push si
mov si,cx
add si,ax
mov di,es
add di,bx
pop bx
call 124 ;getpixel
mov [1114],cl  ;b
db 61
;
db 60
push di
mov si,cx
mov di,es
pop bx
mov cl,[1114]  ;b
xor ax,ax
call 103 ;putpixel
db 61
;
inc cx
cmp cx,[di]
jnz 13e     ;@xloop
mov cx,es
inc cx
mov es,cx
cmp cx,[di+2]
jnz 13c     ;@yloop
pop es
ret
;
;
;
; cs:173 putsprite (set si=source sprite struc;di=dist image struc;
;                       ax=x;bx=y;
;                       cx=mode(0-no clip/no mask,
;                               1-no clip/mask,
;                               2-clip/no mask,
;                               3-clip/mask);
;                       dl=mask color)
mov [1115],cl            ;ch
mov [1116],dl            ;col
push es
xor cx,cx
mov es,cx
;@yloop                 cs:180
xor cx,cx
;@xloop                 cs:182
;
db 60
mov bx,si
mov si,cx
mov di,es
call 124 ;getpixel
mov [1114],cl  ;b
db 61
;
db 60
push di
mov si,cx
add si,ax
mov di,es
add di,bx
pop bx
mov cl,[1114]  ;b
mov ch,[1115] ;ch
cmp ch,0
jz 1b8;@mode0
cmp ch,1
jz 1bc;@mode1
cmp ch,2
jz 1c6;@mode2
cmp ch,3
jz 1cb;@mode3
;
;@mode0  cs:1b8
xor ax,ax
jmp 1d4;@putcall
;
;@mode1  cs:1bc
xor ax,ax
cmp cl,[1116]
jz 1d7  ;@dontput
jmp 1d4  ;@putcall
;
;@mode2  ;1c6
mov ax,1
jmp 1d4;@putcall
;
;@mode3   1cb
mov ax,1
cmp cl,[1116]
jz 1d7;@dontput
;
;@putcall 1d4
call 103 ;putpixel
;@dontput 1d7
db 61
;
inc cx
cmp cx,[si]
jnz 182     ;@xloop
mov cx,es
inc cx
mov es,cx
cmp cx,[si+2]
jnz 180     ;@yloop
pop es
ret
;
;
;
;
;
;
;
;
; cs:1e9 FlipScreen
;Wait for Vsync
mov dx,3da
;@lbl1: cs:1ec
in al,dx
test al,8
je 1ec;@lbl1
;@lbl2: cs:1f1
in al,dx
test al,8
je 1f1;@lbl2
;DrawVscreen
push ds
mov cx,7d00
mov aX,[110c] ;Vscreen
xor si,si
mov bx,a000
xor di,di
mov ds,ax
mov es,bx
rep movsw
pop ds
ret
;
;
;
;
;
; cs:20c fillimage (set dl=color di=image struct pointer)
mov dh,dl
mov ax,[di]
push dx
mov bx,[di+2]
mul bx
pop dx
mov cx,ax
shr cx,1
mov ax,[di+4]
mov es,ax
mov ax,[di+6]
mov di,ax
mov ax,dx
rep stosw
ret
;
;
;
; cs:22a write to pal (set al=numcol;ah=r;bl=g;bh=b)
xchg cx,ax
mov al,ff
mov dx,3c6
out dx,al
mov al,cl
mov dx,3c8
out dx,al
mov al,ch
mov dx,3c9
out dx,al
mov al,bl
mov dx,3c9
out dx,al
mov al,bh
mov dx,3c9
out dx,al
ret
;
;
;
; cs:24a random (get dl=random byte)
mov ax,[11f6] ;randomizer Seed
mov dx,8405
mul dx
inc ax
mov [11f6],ax ;randomizer Seed
mov dh,0
ret
;
;
;
;
; cs:259 hLine (set ax=x1 bx=x2 cx=y dx=color di=image struct pointer)
push es
mov es,di
mov si,ax
mov di,cx
;@xloop 260
db 60
mov bx,es
mov ax,1
mov cl,dl
call 103         ;putpixel
db 61
inc si
cmp si,bx
jb 260;@xloop
pop es
ret
;
;
;
; cs:273 vLine (set ax=x bx=y1 cx=y2 dx=color di=image struct pointer)
push es
mov es,di
mov si,ax
mov di,bx
dec di
;@xloop 27b
inc di
db 60
mov bx,es
mov ax,1
mov cl,dl
call 103           ;putpixel
db 61
cmp di,cx
jnz 27b  ;@xloop
pop es
ret
;
;
;
;
;
;
; cs:28e degtorad(set r=degree; get tb=rad)
;                             w   by cs:1110
;degtorad:=pi*deg/180;
finit
fld tbyte ptr [11e2] ;r
fldpi
fmul
fst tbyte ptr [1158] ;tb
wait
push ax
mov ax,b4
mov [1110],ax ;w
pop ax
finit
fld tbyte ptr [1158] ;tb
fild word ptr [1110] ;w
fdiv
fst tbyte ptr [1158] ;tb
wait
ret
;
;
;
;
;
;
; cs:2b7 scalesprite (set ax=xo,bx=yo,cx=tox,dx=toy;si=sprite,di=dist;
;                         es=mode(0-no clip/no mask,
;                                 1-no clip/mask,
;                                 2-clip/no mask,
;                                 3-clip/mask);
;                         bp=mask color)
;                            tb   by cs:1158
;                           tb1   by cs:1130  - xstep
;                           tb2   by cs:113a  - ystep
;                           tb3   by cs:1162
;                           tb4   by cs:116c
;                             x   by cs:1122  - tox-xo
;                             y   by cs:1124  - toy-yo
;                            xx   by cs:1176  - x
;                            yy   by cs:1178  - y
;                            sy   by cs:1144
;                            sx   by cs:114e
;                            x1   by cs:117a
;                            y1   by cs:117c
;                           col   by cs:1116
;                             w   by cs:1110  - flipmode
;                             i   by cs:1117  - maskcolor
;                            ii   by cs:117e
;
;
;
;
;
;
mov [1110],es ;w - flipmode
mov [1117],bp ;i - maskcolor
;
; xstep:=(spritewidth-1)/(tox-xo);
push cx
sub cx,ax
mov [1122],cx ;x
mov cx,[si]
dec cx
mov [117e],cx ;ii
pop cx
finit
fild word ptr [117e] ;ii
fild word ptr [1122] ;x
fdiv
fst tbyte ptr [1130] ;Xstep tb1
wait
;
; ystep:=spriteheigh/(toy-yo);
; y:=0;
push dx
sub dx,bx
mov [1124],dx  ;y
xor dx,dx
mov [1178],dx ;yy
mov dx,[si+2]
dec dx
mov [117e],dx ;ii
pop dx
finit
fild word ptr [117e] ;(spriteheigh-1) = ii
fild word ptr [1124] ;y
fdiv
fst tbyte ptr [113a] ;ystep tb 2
wait
; sy:=0;
finit
fldz
fst tbyte ptr [1144] ;sy
wait
;
;
;@repeat - YLoop  cs:30f
;  x:=0;
;  sx:=0;
push ax
xor ax,ax
mov [1176],ax ;xx
pop ax
finit
fldz
fst tbyte ptr [114e] ;sx
wait
;@Repeat X-Loop cs:31f
;
finit
fld tbyte ptr [114e] ;sx
fist word ptr [117a] ;x1
wait
finit
fld tbyte ptr [1144] ;sy
fist word ptr [117c] ;y1
wait
;
;   getpixel(round(sx),round(sy),color,sprite);
db 60
mov bx,si
mov si,[117a] ;x1
mov di,[117c] ;y1
call 124      ;getpixel
mov [1116],cl ;col
db 61
;
;   putpixel(xo+x,yo+y,color,dist);
db 60
add ax,[1176] ;xx
push ax
add bx,[1178] ;yy
push bx
mov bx,di
pop di
pop si
;****  cs:357
mov ax,[1110] ;w - flipmode
mov ch,al
mov cl,[1116] ;col
cmp ch,0
jz 374;@mode0
cmp ch,1
jz 378;@mode1
cmp ch,2
jz 382;@mode2
cmp ch,3
jz 387;@mode3
;
;@mode0  cs:374
xor ax,ax
jmp 390;@putcall
;
;@mode1  cs:378
xor ax,ax
cmp cl,[1117] ; - msakcolor 117c
jz 393 ;@dontput
jmp 390;@putcall
;
;@mode2  ;382
mov ax,1
jmp 390;@putcall
;
;@mode3   387
mov ax,1
cmp cl,[1117]
jz 393 ;@dontput
;
;@putcall 390
call 103 ;putpixel
;@dontput 393
db 61
;
;
;   sx:=sx+stepx;
finit
fld tbyte ptr [114e] ;sx
fld tbyte ptr [1130] ;stepx
fadd
fst tbyte ptr [114e] ;sx
wait
;
;   inc(x);
push ax
mov ax,[1176] ;xx
inc ax
mov [1176],ax ;xx
pop ax
;
push ax
mov ax,[1176] ;xx
mov bp,ax ;xx
pop ax
;  until x=tox-xo;  cs:3ed
cmp bp,[1122] ; xx ? tox-xo :3ea
jz 3be ;@unten
jmp 31f ;@Xloop
;@unten cs:3be
;
;  sy:=sy+stepy;
finit
fld tbyte ptr [1144] ;sy
fld tbyte ptr [113a] ;stepY
fadd
fst tbyte ptr [1144] ;sy
wait
;
;  inc(y);
push ax
mov ax,[1178] ;yy
inc ax
mov [1178],ax ;yy
;
mov bp,ax ;yy
pop ax
;
; until y=toy-yo;
cmp bp,[1124] ;toy-yo   40f
jz 3e3   ;@nachunten
jmp 30f ;@YLoop
;@unten cs:3e3
ret
;
;
;
;
; cs:3e4 rotateSprite (set ax=zdwigX, bx=zdwigY, cx=midX, dx=midY,
;                          si=sprite image, di=dist screen,
;                          tb=rotateAngle, bp=mask color)
;
;
;
;used vars
;                tb     by cs:1158      rotangle
;                i1     by cs:11c6       spriteImage
;                i2     by cs:11c8      distScreen
;                x1     by cs:117a       midX
;                y1     by cs:117c       midY
;                x2     by cs:25ea       zdwigX
;                y2     by cs:11b4       zdwigY
;               tb1     by cs:1130      mysin
;               tb2     by cs:113a      mycos
;               col     by cs:1116      col
;                 w     by cs:1110       w
;                x3     by cs:11b6   minX
;                y3     by cs:11b8   minY
;                x4     by cs:11ba   maxX
;                y4     by cs:11bc   maxY
;               tb8     by cs:1194      myYsin
;               tb9     by cs:119e      myYcos
;                 r     by cs:11e2      r
;                xx     by cs:1176      roundedX
;                yy     by cs:1178      roundedY
;                sy     by cs:1144      singleY
;                sx     by cs:114e      singleX
;                x7     by cs:11c2 newx
;                y7     by cs:11c4 newy
;                ii     by cs:117e      mode
;                bb     by cs:1119      maskcolor
;                            x6   by cs:11de tempX
;                            x5   by cs:11be oldX
;
;
mov [11c6],si   ;sprite image
mov [11c8],di   ;dist screen
mov [117a],cx   ;midX
mov [117c],dx   ;midY
mov [25ea],ax   ;zdwigX
mov [11b4],bx   ;zdwigY
mov [117e],es   ;mode
mov ax,bp
mov [1119],al   ;maskcolor
;
;
;mysin:=sin(angle);
;mycos:=cos(angle);
finit
fld tbyte ptr [1158] ;tb
;fsincos
db d9,fb
fstp tbyte ptr [113a] ;mycos
fst tbyte ptr [1130]  ;mysin
wait
;
;
;
;
;                            x4   by cs:11ba   maxX
;maxx:=sourceSprite.width-midX;
mov ax,[si] ;sprite.width
dec ax
sub ax,cx ;midx
mov [11ba],ax ;maxX
;
;                            x3   by cs:11b6   minX
;minx:=0-midx;
mov ax,cx ;midx
xor bx,bx
sub bx,ax
mov [11b6],bx ;minX
;
;MinY:=0-midY;
;                            y3   by cs:11b8   minY
mov ax,dx ;midy
xor bx,bx
sub bx,ax
mov [11b8],bx ;miny
;
;
;                            y4   by cs:11bc   maxY
;maxY:=sourceSprite.heigh-midY;
mov ax,[si+2] ;sourceSprite.heigh
dec ax
mov bx,dx ;midy
sub ax,bx
mov [11bc],ax ;maxy
;
;
;
;
;
finit
 fild word ptr [11b8] ;miny
 fst tbyte ptr [1144] ;singleY
wait
;
;
;for Y:=MinY to MaxY do begin
;
;@YLoopPoint cs:447
;
;
;
;
;
;
;               tb8     by offset cs:1194       myYsin
;               tb9     by offset cs:119e       myYcos
;               tb1     by offset cs:1130       mysin
;               tb2     by offset cs:113a       mycos
;
;  myYsin:=Y*mysin;
finit
 fld tbyte ptr [1144] ;singleY
 fld tbyte ptr [1130] ;mysin
 fmul
 fst tbyte ptr [1194] ; myYsin
wait
;  myYcos:=Y*mycos;
finit
 fld tbyte ptr [1144] ;singleY
 fld tbyte ptr [113a] ; mycos
 fmul
 fst tbyte ptr [119e] ; myYcos
wait
;
;
;
;
;
;
;
finit
 fild word ptr [11b6] ;minx
 fst tbyte ptr [114e] ;singleX
wait
;
;
; for x:=MinX to MaxX do begin
;
;
;@XLoopPoint cs:474
;
;
;  getpixel(x+midX,y+midY,sourcesprite,color);
;
;
finit
 fld tbyte ptr [114e] ;singleX
 fist word ptr [1176] ; roundedX
wait
finit
 fld tbyte ptr [1144] ;singleY
 fist word ptr [1178] ; roundedY
wait
;
mov si,[1176] ; roundedX
add si,[117a] ;midX
mov di,[1178] ; roundedY
add di,[117c] ;midY
mov bx,[11c6] ;sprite image
call 124      ;getpixel (set si=x;di=y;bx=image struct pointer; get cl=color)
mov [1116],cl ;col
;
;
mov al,[1119]
cmp al,cl
jnz 4ae ;@unten
jmp 517 ;MASKCOLORSKIP
;@unten 4ae
;
;
;
;
;
;   newx:=round(X*mycos-myYsin)+midX;
;
finit
 fld tbyte ptr [114e] ;singleX
 fld tbyte ptr [113a] ; mycos
 fmul
 fst tbyte ptr [11e2] ; r
wait
finit
 fld tbyte ptr [11e2] ; r
 fld tbyte ptr [1194] ; myYsin
 fsub
 fist word ptr [11c2] ;newx
wait
;
;
;
;
;   newy:=round(X*mysin+myYcos)+midy;
finit
 fld tbyte ptr [114e] ;singleX
 fld tbyte ptr [1130] ; mysin
 fmul
 fst tbyte ptr [11e2] ; r
wait
finit
 fld tbyte ptr [11e2] ; r
 fld tbyte ptr [119e] ; myYcos
 fadd
 fist word ptr [11c4] ; newY
wait
;
;
;
;
;
mov ax,[11c2] ;newx
mov [11de],ax ; tempX
;
;
; PLOTPIXEL
call 56a
;
;
;
;
;                            x6   by cs:11de tempX
;                            x5   by cs:11be oldX
;
;@Repeat 4fb
;
mov ax,[11c2] ; newx
inc ax
mov [11c2],ax ; newx
;
;
;
;PLOTPIXEL
call 56a
;
;
;
mov ax,[11c2] ; newx
sub ax,[11be] ; oldX
cmp ax,1
jb 4fb ;@repaet
;
;
;
mov ax,[11de] ; tempX
mov [11be],ax ;oldX
;
;
;
;
;@MASKCOLORSKIP 517
;
finit
 fld tbyte ptr [114e] ;singleX
 fld1
 fadd
 fst tbyte ptr [114e] ;singleX
wait
;
;
finit
 fld tbyte ptr [114e] ;singleX
 fild word ptr [11ba] ; maxx
fcom
fstsw word ptr [1110] ;w
wait
mov ax,[1110] ;w
sahf
jc 540 ;@label1
jmp 474 ;@Xloop
;@label1 540
;
;
;
;
;
finit
 fld tbyte ptr [1144] ;singleY
 fld1
 fadd
 fst tbyte ptr [1144] ;singleY
wait
;
;
;
finit
 fld tbyte ptr [1144] ;singleY
 fild word ptr [11bc] ;maxy
fcom
fstsw word ptr [1110] ;w
wait
mov ax,[1110] ;w
sahf
jc 569 ;@label2
jmp 447 ;@Yloop
;@label2 569
;
;
;
;
ret
;
;PLOTPIXEL FOR ROTATE SPRITE  56a
;    putpixel(newx+zdwigX,newy+zdwigY,color,distpic);
;
mov si,[11c2] ; newx
add si,[117a] ; midX
add si,[25ea] ;zdwigX
;
mov di,[11c4] ; newY
add di,[117c] ; midY
add di,[11b4] ;zdwigY
;
mov bx,[11c8]   ;dist screen
mov ax,1 ;Clipp
mov cl,[1116] ;col
call 103 ;putpixel
ret
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;*******************************************************************
;*************************** THE INTRO *****************************
;*******************************************************************
;
;
;
;
;
;cs:591    KelthicMuster!
;                             x   by cs:1122
;                             y   by cs:1124
;                           col   by cs:1116
;                          tb10   by cs:11a8
;                             r   by cs:11e2
;
;a - 5a / 28   : a0 / 28 h
mov ax,5a ;x1
mov bx,a1 ;x2
mov cx,28 ;y
mov dx,7 ;col
mov di,1108 ;image
call 259 ;hLine
;
;b - 78 / a    : 78 / 50 v
mov ax,78 ;x
mov bx,a  ;y1
mov cx,50 ;y2
mov dx,7 ;col
mov di,1108 ;image
call 273 ;vLine
;
;c - 5a / a    : 78 / a  h
mov ax,5a ;x1
mov bx,78 ;x2
mov cx,a ;y
mov dx,7 ;col
mov di,1108 ;image
call 259 ;hLine
;
;d - 5a / a    : 5a / 28 v
mov ax,5a ;x
mov bx,a  ;y1
mov cx,28 ;y2
mov dx,7 ;col
mov di,1108 ;image
call 273 ;vLine
;
;e - 50 / 32   : 6e / 32 h
mov ax,50 ;x1
mov bx,6e ;x2
mov cx,32 ;y
mov dx,7 ;col
mov di,1108 ;image
call 259 ;hLine
;
;s - 6e / 32   : 6e / 5a v
mov ax,6e ;x
mov bx,32  ;y1
mov cx,5a ;y2
mov dx,7 ;col
mov di,1108 ;image
call 273 ;vLine
;
;f - 50 / 32   : 50 / 50 v
mov ax,50 ;x
mov bx,32  ;y1
mov cx,50 ;y2
mov dx,7 ;col
mov di,1108 ;image
call 273 ;vLine
;
;g - 50 / 50   : 78 / 50 h
mov ax,50 ;x1
mov bx,78 ;x2
mov cx,50 ;y
mov dx,7 ;col
mov di,1108 ;image
call 259 ;hLine
;
;h - 14 / 5a   : 6e / 5a h
mov ax,14 ;x1
mov bx,6e ;x2
mov cx,5a ;y
mov dx,7 ;col
mov di,1108 ;image
call 259 ;hLine
;
;k - 14 / 3c   : 32 / 3c h
mov ax,14 ;x1
mov bx,32 ;x2
mov cx,3c ;y
mov dx,7 ;col
mov di,1108 ;image
call 259 ;hLine
;
;i - 32 / 3c   : 32 / 64 v
mov ax,32 ;x
mov bx,3c  ;y1
mov cx,64 ;y2
mov dx,7 ;col
mov di,1108 ;image
call 273 ;vLine
;
;q - 8c / 50   : 8c / 64 v
mov ax,8c ;x
mov bx,50  ;y1
mov cx,64 ;y2
mov dx,7 ;col
mov di,1108 ;image
call 273 ;vLine
;
;r - 8c / 50   : a0 / 50 h
mov ax,8c ;x1
mov bx,a1 ;x2
mov cx,50 ;y
mov dx,7 ;col
mov di,1108 ;image
call 259 ;hLine
;
;p - 1e / a    : 3c / a  h
mov ax,1e ;x1
mov bx,3c ;x2
mov cx,a ;y
mov dx,7 ;col
mov di,1108 ;image
call 259 ;hLine
;
;o - 1e / a    : 1e / 28 v
mov ax,1e ;x
mov bx,a  ;y1
mov cx,28 ;y2
mov dx,7 ;col
mov di,1108 ;image
call 273 ;vLine
;
;m - 3c / a    : 3c / 28 v
mov ax,3c ;x
mov bx,a  ;y1
mov cx,28 ;y2
mov dx,7 ;col
mov di,1108 ;image
call 273 ;vLine
;
;n - 1e / 28   ; 3c / 28 h
mov ax,1e ;x1
mov bx,3c ;x2
mov cx,28 ;y
mov dx,7 ;col
mov di,1108 ;image
call 259 ;hLine
;
;k - 14 / 3c  :  14 / 5a v
mov ax,14 ;x
mov bx,3c  ;y1
mov cx,5a ;y2
mov dx,7 ;col
mov di,1108 ;image
call 273 ;vLine
;
;
;6d5
;
;
xor ax,ax
mov [1124],ax ;y
;@Yloop 6da
xor ax,ax
mov [1122],ax ;x
;@Xloop 6df
;
mov ax,[1122] ;x
mov si,a0
sub si,ax
mov ax,[1124] ;y
mov di,64
sub di,ax
mov bx,1108
call 124; getpixel
mov [1116],cl
;
mov ax,[1122] ;x
mov si,a0
add si,ax
mov ax,[1124] ;y
mov di,64
sub di,ax
mov bx,1108
mov cl,[1116]
mov ax,1
call 103 ;putpixel
;
mov ax,[1122]
inc ax
mov [1122],ax
cmp ax,a0
jnz 6df
;
;
mov ax,[1124]
inc ax
mov [1124],ax
cmp ax,64
jnz 6da
;
;
;
;
;
;
;
xor ax,ax
mov [1124],ax ;y
;@Yloop 733
xor ax,ax
mov [1122],ax ;x
;@Xloop 738
;
mov ax,[1122] ;x
mov si,ax
mov ax,[1124] ;y
mov di,64
sub di,ax
mov bx,1108
call 124; getpixel
mov [1116],cl
;
mov ax,[1122] ;x
mov si,ax
mov ax,[1124] ;y
mov di,ax
add di,64
mov bx,1108
mov cl,[1116]
mov ax,1
call 103 ;putpixel
;
mov ax,[1122]
inc ax
mov [1122],ax
cmp ax,140
jnz 738
;
;
mov ax,[1124]
inc ax
mov [1124],ax
cmp ax,64
jnz 733
;
;
;
;
;
;
;
;
;781
;
;add angle
finit
fld tbyte ptr [11a8] ;tb10
fld1
fadd
fst tbyte ptr  [11a8] ;tb10
wait
;
;
;
;
finit
fld tbyte ptr [11a8] ;tb10
fst tbyte ptr  [11e2] ;r
wait
;
;
call 28e ; degtorad(set r=degree; get tb=rad)
;
;79e
mov ax,0
mov bp,ax
mov ax,90 ;zdwigx
mov bx,54 ;zdwigY
mov cx,10 ;midx
mov dx,10 ;midy
mov si,18b4
mov di,1108
call 3e4
;
;
;
;
ret
;****************** do Effect ;*************** Kelth Muster ************************
;7b9
;
mov al,0 ;col
mov ah,3f ;r
mov bl,3f ;g
mov bh,3f ;b
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
mov al,7 ;col
mov ah,3f ;r
mov bl,3f ;g
mov bh,3f ;b
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
;
mov al,3f
mov [112c],al ;col7
xor ax,ax
mov [1112],ax
;                            ww   by cs:1112
;
;
;
;***MAINLOOP**
;@mainloop  cs:7d9
;
;
;
;
Mov dl,0
mov di,1108
call 20c ; fillimage (set dl=color di=image struct pointer)
;
;
;
;
;
call 591        ;proceed Kelth Effect
;
;
;                          col7   by cs:112c
mov ax,[1112]   ;ww
cmp ax,3e
ja 805 ;@jumpweiter
;fade in
mov al,[112c]   ;col7
dec al
mov [112c],al   ;col7
mov al,7 ;col
mov ah,[112c]  ;col7 ;r
mov bl,[112c]  ;col7 ;g
mov bh,[112c]  ;col7 ;b
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
;
;
;@jumpweiter 805
;
;
mov ax,[1112]   ;ww
cmp ax,1c2 ;!!!!!!!!!!!!!!!!!!!!!!!!!
jb 826 ;@jumpnochweiter
;fade in
mov al,[112c]   ;col7
dec al
mov [112c],al   ;col7
mov al,0 ;col
mov ah,[112c]  ;col7 ;r
mov bl,[112c]  ;col7 ;g
mov bh,[112c]  ;col7 ;b
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
;
;
;@jumpnochweiter  826
;
;
call 1e9 ;FlipScreen
;
mov ax,[1112] ;ww
inc ax
mov [1112],ax ;ww
;
mov ax,[1112] ;ww
cmp ax,200 ;!!!!!!!!!!!!!!!!!!
jb 7d9 ;@mainloop
ret
;
;
;
;
;
;
;
;
;
;
;
;
;*********************************************************************
;*********** SMILY 1 ***************************************************
;!!!! Transpartentcolor in sprites 7 !!!!!!
;bb   by cs:1119 - the way flag 1 or 2 !!!!
;839
Mov dl,0
mov di,1100
call 20c ; fillimage (set dl=color di=image struct pointer)
;
xor ax,ax
;@SetUP PAL - UP  843
inc al     ;col
mov ah,al  ;col7 ;r
mov bl,al  ;col7 ;g
mov bh,al  ;col7 ;b
db 60
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
db 61
cmp al,40
jnz 843;@Setup - UP 843
;
;@SetUP PAL - down   854
dec al     ;col
mov ah,al  ;col7 ;r
mov bl,al  ;col7 ;g
mov bh,al  ;col7 ;b
db 60
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
db 61
cmp al,0
jnz 854;@Setup - down 854
;
mov al,40
;@SetUP PAL - rest  867
inc al     ;col
mov ah,0  ;col7 ;r
mov bl,0  ;col7 ;g
mov bh,0  ;col7 ;b
db 60
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
db 61
cmp al,ff
jnz 867;@Setup - rest 867
;
;
;
mov ax,[1112] ;ww
cmp ax,1
jz 885  ;@mode1
cmp ax,2
jz 88a  ;@mode2
;
;@mode1  885
mov dx,-50
jmp 88d ;@go
;@mode2  88a
mov dx,147
;@go   88d
;
;*****  MAIN LOOP **** ***    88d
;
db 60
;
Mov dl,0
mov di,111a  ;tempscreen
call 20c ; fillimage (set dl=color di=image struct pointer)
Mov dl,0
mov di,1108  ;vscreen
call 20c ; fillimage (set dl=color di=image struct pointer)
;
; draw lines 1
xor ax,ax
mov bx,140
xor cx,cx
;@l1 8a5
inc cx
mov dx,cx
mov di,1108     ;vscreen
db 60
add cx,24
call 259 ;hLine (set ax=x1 bx=x2 cx=y dx=color di=image struct pointer)
db 61
cmp cx,40
jb 8a5 ;@l1
;
; draw lines 2
xor ax,ax
mov bx,140
mov cx,3f
mov dx,cx
;@l2 8c2
inc cx
dec dx
mov di,1108     ;vscreen
db 60
add cx,24
call 259 ;hLine (set ax=x1 bx=x2 cx=y dx=color di=image struct pointer)
db 61
cmp cx,80
jb 8c2 ;@l2
;
;
;RATATE WAY
mov ax,[1112] ;ww
cmp ax,1
jz 8e2;@mode1
cmp ax,2
jz 8f3;@mode2
;@MODE1  8e2
;add angle
finit
fld tbyte ptr [11a8] ;tb10
fld1
fadd
fst tbyte ptr  [11a8] ;tb10
wait
;
jmp 902;@go
;@MODE2 8f3
;sub angle
finit
fld tbyte ptr [11a8] ;tb10
fld1
fsub
fst tbyte ptr  [11a8] ;tb10
wait
;
;@go 902
;
;
finit
fld tbyte ptr [11a8] ;tb10
fst tbyte ptr  [11e2] ;r
wait
;
;
call 28e ; degtorad(set r=degree; get tb=rad)
;
;
db 61
mov ax,0
mov bp,ax
mov ax,dx ;zdwigx
db 60
mov bx,44 ;zdwigY
mov cx,20 ;midx
mov dx,20 ;midy
mov si,1ed6
mov di,111a
call 3e4 ;Rotate Sprite
;
;
mov ax,0 ;zdwigx
mov bx,0 ;zdwigY
mov cx,3
mov dx,7
mov si,111a
mov di,1108
call  173  ;putsprite
;
call 1e9 ;FlipScreen
;
;
;
db 61
;
;
;
mov ax,[1112] ;ww
cmp ax,1
jz 951 ;mode1
;
cmp ax,2
jz 95b ;mode2
;@mode1 951
inc dx
cmp dx,148
jz 964  ;@the end
jmp 88d ;@MAINLOOP
;
;@mode2  95b
dec dx
cmp dx,-50
jz 964  ;@the end
jmp 88d ;@MAINLOOP
;@the end  964
;
;
ret
;
;
;
;
; **** FIRE  *****
;setuppal 965
;
;for i:=f to 64 do
; setpal(i,63,(i-f)*63 div 32,0);
mov cx,f
;@thirdloop  968
xor ax,ax
mov [1116],cl ;col
push cx
mov ax,3f
mov [1126],al ;col1 - r
mov ax,cx
sub ax,f
mov cx,3f
mul cx
mov cx,20
div cx
mov [1127],al ;col2 - g
xor cx,cx
mov [1128],cl ;col3 - b
pop cx
db 60
mov al,[1116] ;col
mov ah,[1126] ;col1
mov bl,[1127] ;col2
mov bh,[1128] ;col3
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
db 61
inc cx
cmp cx,38
jb 968;@thirdloop
;
;
;
mov ax,38
;@SetUP PAL - UP  9ab
inc al     ;col
mov ah,al  ;col7 ;r
mov bl,al  ;col7 ;g
mov bh,al  ;col7 ;b
db 60
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
db 61
cmp al,72
jnz 9ab;@Setup - UP 9ab
;
;@SetUP PAL - down  9bc
dec al     ;col
mov ah,al  ;col7 ;r
mov bl,al  ;col7 ;g
mov bh,al  ;col7 ;b
db 60
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
db 61
cmp al,38
jnz 9bc;@Setup - down 9bc
;
mov al,72
;@SetUP PAL - rest  9cf
inc al     ;col
mov ah,0  ;col7 ;r
mov bl,0  ;col7 ;g
mov bh,0  ;col7 ;b
db 60
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
db 61
cmp al,ff
jnz 9cf;@Setup - rest 9cf
ret
;
;
;
;
;9e1 getpixels
;
db 60
mov si,[1122] ;x
dec si
mov di,[1124] ;y
mov bx,111a ;tempscreen
call 124 ;getpixel
mov [1126],cl ;col1
db 61
db 60
mov si,[1122] ;x
inc si
mov di,[1124] ;y
mov bx,111a ;tempscreen
call 124 ;getpixel
mov [1127],cl ;col2
db 61
db 60
mov si,[1122] ;x
mov di,[1124] ;y
mov bx,111a ;tempscreen
call 124 ;getpixel
mov [1128],cl ;col3
db 61
db 60
mov si,[1122] ;x
mov di,[1124] ;y
inc di
mov bx,111a ;tempscreen
call 124 ;getpixel
mov [1129],cl ;col4
db 61
;
mov cl,[1126] ;col1
add cl,[1127] ;col2
add cl,[1128] ;col3
add cl,[1129] ;col4
shr cl,1
shr cl,1
cmp cl,f
ja a4f ;@Nozerrowing
xor cl,cl
;@nozerrowing a4f
mov [1116],cl ;col
ret
;
;
;
;a54 random ground
mov ax,2
;@Yloop a57
mov cx,140
;@Xloop a5a
db 60
call 24a ;random
shr dl,1
shr dl,1
mov [1114],dl ;b
db 61
db 60
mov si,cx
mov di,c5
add di,ax
mov bx,111a ;tempscreen
mov ax,1
mov cl,[1114] ;b
call 103 ;putpixel
db 61
dec cx
jnz a5a ;@XLoop
dec ax
cmp ax,0
jnz a57 ;@yLoop
ret
;
;
;
;
;a87  make fire
mov ax,98
mov [1124],ax   ;y
;
;@Yloop  a8d
mov ax,1
mov [1122],ax   ;x
;
;@Xloop  a93
;
;
;
;
;
;
call 9e1 ;getpixels
;
;
;
;putpixel
db 60
mov si,[1122] ;x
mov di,[1124] ;y
dec di
mov bx,111a ;tempScreen
mov ax,1
mov cl,[1116] ;col
call 103
db 61
;
;
mov cx,[1122] ;x
inc cx
mov [1122],cx ;x
cmp cx,13f
jb a93 ;@Xloop
;
mov cx,[1124] ;y
inc cx
mov [1124],cx ;y
cmp cx,c7
jb a8d ;@Yloop
;
ret
;
;
;
;acd draw lines 2
;
xor ax,ax
mov bx,140
xor cx,cx
;@l1 ad4
inc cx
mov dx,cx
add dx,40
mov di,1108
db 60
call 259 ;hLine (set ax=x1 bx=x2 cx=y dx=color di=image struct pointer)
db 61
cmp cx,40
jb ad4 ;@l1
;
;
;
xor ax,ax
mov bx,140
mov cx,2f
mov dx,cx
;@l1 af1
inc cx
dec dx
mov di,1108
db 60
add dx,40
call 259 ;hLine (set ax=x1 bx=x2 cx=y dx=color di=image struct pointer)
db 61
cmp cx,5e
jb af1 ;@l1
;
;
ret
;
;
;
;
;FIRE!! b04
;
;
;
call 965
;
xor ax,ax
mov [1112],ax ;ww   by cs:1112
;***MAINLOOP**
;@mainloop  cs:b0c
;
;
;
;
;
;
;
;
;
Mov dl,0
mov di,1108
call 20c ; fillimage (set dl=color di=image struct pointer)
;
;
;
call acd ;draw lines 2
;
mov ax,[1112] ;ww   by cs:1112
cmp ax,190
ja b22 ;@SkipGround
call a54 ;random ground
;@SkipGround b22
call a87 ;make fire
;
mov di,111a ;tempScreen
xor ax,ax
mov bx,140
mov cx,c7
xor dx,dx
db 60
call 259 ;hLine (set ax=x1 bx=x2 cx=y dx=color di=image struct pointer)
db 61
mov cx,c6
call 259 ;hLine (set ax=x1 bx=x2 cx=y dx=color di=image struct pointer)
;
;
;putSmile
mov ax,0
mov bp,ax
mov es,ax
mov ax,70
mov bx,0
mov cx,c0
mov dx,60
mov si,1820 ;smily2
mov di,111a ;tempScreen
call 2b7 ;scalesprite
;
;draw everything
;
mov si,111a
mov di,1108
mov ax,0
mov bx,0
mov cx,1
mov dl,7
call 173; putsprite
;
;
;
;
call 1e9 ;FlipScreen
;
;
;do until
;
mov ax,[1112] ;ww   by cs:1112
inc ax
mov [1112],ax ;ww   by cs:1112
cmp ax,200
jb b0c ;@mainloop
ret
;
;
;
;
;
;b7d *** Crying Hart ***
Mov dl,0
mov di,1108
call 20c ; fillimage (set dl=color di=image struct pointer)
;
xor cx,cx
;@drawaline cs:b87
push cx
mov si,cx
mov di,0
call 24a ;random
xor dh,dh
shr dx,1
shr dx,1
mov cx,dx
mov bx,1108
call 103
pop cx
inc cx
cmp cx,140
jnz b87 ;@drawline
;
;
;
;SetupPalette
xor cx,cx
;@aloop ba8
push cx
mov al,cl
mov ah,cl
xor bx,bx
call 22a
pop cx
inc cx
cmp cx,40
jnz ba8 ;@aloop
;
;
;
;
;Draw the Rain  bb9
;
;
xor si,si
;@Xloop bbb
push si
mov di,1
;@Yloop bbf
push di
;
mov bx,1108
mov cx,a
push di
push si
dec di
call 124
pop si
pop di
mov bx,1108
cmp cx,1
ja bd9  ;@notnewdrop
mov cx,3f
;@notdewdrop bd9
dec cx
push di
push si
push ax
mov ax,1
call 103
pop ax
pop si
pop di
;
pop di
inc di
cmp di,c8
jnz bbf ;yloop
pop si
inc si
cmp si,140
jnz bbb;@xloop
;
;
;bf6
;
Mov dl,0
mov di,111a
call 20c ; fillimage (set dl=color di=image struct pointer)
;
mov ax,0
mov es,ax
mov ax,0
mov bp,ax
mov ax,50
mov bx,20
mov cx,f0
mov dx,b0
mov si,1cbe     ; Hart symbol
mov di,111a
call 2b7 ;scalesprite
;
mov si,111a
mov di,1108
mov ax,0
mov bx,0
mov cx,3
mov dl,1
call 173 ;putsprite
;
call 1e9 ;FlipScreen
;
mov cx,1
xor dx,dx
mov [1112],dx ;ww   by cs:1112
;@mailloop c3d
;
;
mov cx,1
;@myloop c40
;
push cx
push dx
mov al,cl
mov ah,cl
add ah,dl
xor bx,bx
call 22a
pop dx
pop cx
;
inc cx
cmp cx,40
jnz c40 ;@myloop
;
inc dl ;
;
db 60
call 1e9 ;FlipScreen
db 61
;
mov ax,[1112] ;ww   by cs:1112
inc ax
mov [1112],ax
cmp ax,300
jnz c3d ;@mainloop
;
;
ret
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
; ** c69
;FADEINCOLOR7 c69
xor dx,dx
;@theloop1  c6b
mov al,7
mov ah,dl
mov bl,dl
mov bh,dl
db 60
call 22a  ;setpal
call 1e9 ;FlipScreen
db 61
inc dx
cmp dx,40
jb c6b ;@theloop1
ret
;FADEOUTCOLOR7 c82
mov dx,3f
;@theloop2 c85
mov al,7
mov ah,dl
mov bl,dl
mov bh,dl
db 60
call 22a ;setpal
call 1e9 ;FlipScreen
db 61
dec dx
cmp dx,0
ja c85 ;@theloop2
ret
;
;
;
;
;** INTRO: CREDITS *** c9c
;
;
;
mov dl,0
mov di,1108
call 20c ;fillimage (set dl=color di=image struct pointer)
;
mov si,1220
mov di,1108
mov ax,78
mov bx,60
mov cx,0
mov dl,0
call 173; putsprite
;
call c69 ;FADEINCOLOR7
;
;
xor dx,dx
;@aloop1 cbd
db 60
call 1e9 ;FlipScreen
db 61
inc dx
cmp dx,120
jb cbd ;@aloop1
;
;
;
call c82 ;FADEOUTCOLOR7
;
;
;
mov dl,0
mov di,1108
call 20c ;fillimage (set dl=color di=image struct pointer)
;
mov si,144c
mov di,1108
mov ax,68
mov bx,60
mov cx,0
mov dl,0
call 173; putsprite
;
call c69 ;FADEINCOLOR7
;
;
xor dx,dx
;@aloop1 ced
db 60
call 1e9 ;FlipScreen
db 61
inc dx
cmp dx,120
jb ced ;@aloop1
;
;
;
call c82 ;FADEOUTCOLOR7
;
ret
;
;
;
;
;
; -> now ->   cs:cfd
;
;
;
;
;
;  InitSystem
;Setup a000 struct
mov di,1100     ;width
mov ax,140
mov [di],ax
mov di,1102     ;heigh
mov ax,c8
mov [di],ax
mov di,1104     ;data segment
mov ax,a000
mov [di],ax
mov di,1106     ;data offset
mov ax,0
mov [di],ax
;cut memory
xor ax,ax
mov bx,4096
mov ah,4a
int 21
;MALLOC VSCREEN
xor ax,ax
mov bx,fa0
mov ah,48
int 21
mov [1110],ax ;w
;Setup a VSCREEN image
mov di,1108     ;width
mov ax,140
mov [di],ax
mov di,110a     ;heigh
mov ax,c8
mov [di],ax
mov di,110c     ;data segment
mov ax,[1110]
mov [di],ax
mov di,110e     ;data offset
mov ax,0
mov [di],ax
;MALLOC tempscreen
xor ax,ax
mov bx,fa0
mov ah,48
int 21
mov [1110],ax ;w
;Setup a temp image
mov di,111a     ;width
mov ax,140
mov [di],ax
mov di,111c     ;heigh
mov ax,c8
mov [di],ax
mov di,111e     ;data segment
mov ax,[1110]   ;w
mov [di],ax
mov di,1120     ;data offset
mov ax,0
mov [di],ax
;init randomizer
push ds
mov bx,040 ;BIOS data seg
mov ds,bx
mov ax,[6C] ;lowtimer
pop ds
mov [11f6],ax
;set graph mode
MOV     AX,0013
INT     10
; write text (set ds:dx=a'$' ending string pointer)
mov dx,10df  ; the Strings offset
mov ah,9
int 21
;
;
;"PSYCH 66" sprite
mov di,1220     ;width
mov ax,4d
mov [di],ax
mov di,1222     ;heigh
mov ax,07
mov [di],ax
mov di,1224     ;data segment
mov ax,cs
mov [di],ax
mov di,1226     ;data offset
mov ax,1228
mov [di],ax
;grab sprite
mov si,1100
mov di,1220
mov ax,1
mov bx,0
call 137 ; getsprite
;
;
; 'Code: Key-Real' sprite
mov di,144c     ;width
mov ax,70
mov [di],ax
mov di,144e     ;heigh
mov ax,08
mov [di],ax
mov di,1450     ;data segment
mov ax,cs
mov [di],ax
mov di,1452     ;data offset
mov ax,1454
mov [di],ax
;grab sprite
mov si,1100
mov di,144c
mov ax,4f
mov bx,0
call 137 ; getsprite
;
;
;'first smily sybol' sprite   by cs:17d6
mov di,17d6     ;width
mov ax,08
mov [di],ax
mov di,17d8      ;heigh
mov ax,08
mov [di],ax
mov di,17da     ;data segment
mov ax,cs
mov [di],ax
mov di,17dc     ;data offset
mov ax,17de
mov [di],ax
;grab sprite
mov si,1100
mov di,17d6
mov ax,0
mov bx,8
call 137 ; getsprite
;
;
;
;          'second smily sybol'sprite   by cs:1820
mov di,1820     ;width
mov ax,08
mov [di],ax
mov di,1822      ;heigh
mov ax,08
mov [di],ax
mov di,1824     ;data segment
mov ax,cs
mov [di],ax
mov di,1826     ;data offset
mov ax,1828
mov [di],ax
;grab sprite
mov si,1100
mov di,1820
mov ax,8
mov bx,8
call 137 ; getsprite
;
;
;
;         'fourth sybol= the raute' sprite   by cs:186a
mov di,186a     ;width
mov ax,07
mov [di],ax
mov di,186c      ;heigh
mov ax,07
mov [di],ax
mov di,186e     ;data segment
mov ax,cs
mov [di],ax
mov di,1870     ;data offset
mov ax,187b
mov [di],ax
;grab sprite
mov si,1100
mov di,186a
mov ax,18
mov bx,8
call 137 ; getsprite
;
;
;
;
;
; ******** !!!!!!!!!! **************** !!!!!!!!!!!!!!!!  ->
;        'hart symbol' sprite   by cs:1cbe
mov di,1cbe     ;width
mov ax,18
mov [di],ax
mov di,1cc0      ;heigh
mov ax,16
mov [di],ax
mov di,1cc2     ;data segment
mov ax,cs
mov [di],ax
mov di,1cc4     ;data offset
mov ax,1cc6
mov [di],ax
;
;
;
;            'big raute' sprite   by cs:18b4
mov di,18b4     ;width
mov ax,20
mov [di],ax
mov di,18b6     ;heigh
mov ax,20
mov [di],ax
mov di,18b8     ;data segment
mov ax,cs
mov [di],ax
mov di,18ba     ;data offset
mov ax,18bc
mov [di],ax
;
mov ax,0
mov es,ax
mov ax,0
mov bp,ax
mov si,186a
mov di,18b4
mov ax,0
mov bx,0
mov cx,20
mov dx,20
call 2b7 ;scalesprite
;
;
;
;
;         ':)' sprite   by cs:2ede
mov di,2ede     ;width
mov ax,0e
mov [di],ax
mov di,2ee0      ;heigh
mov ax,07
mov [di],ax
mov di,2ee2     ;data segment
mov ax,cs
mov [di],ax
mov di,2ee4     ;data offset
mov ax,2ee6
mov [di],ax
;grab sprite
mov si,1100
mov di,2ede
mov ax,20
mov bx,8
call 137 ; getsprite
;
;
;
;
ret
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;cs:f09
;program entrypoint
;
;
;* INIT *;
call cfd
call fe1
;           'big Smile1' sprite   by cs:1ed6
mov di,1ed6     ;width
mov ax,40
mov [di],ax
mov di,1ed8     ;heigh
mov ax,40
mov [di],ax
mov di,1eda     ;data segment
mov ax,cs
mov [di],ax
mov di,1edc     ;data offset
mov ax,1ede
mov [di],ax
;
mov ax,0
mov es,ax
mov ax,0
mov bp,ax
mov si,17d6
mov di,1ed6
mov ax,0
mov bx,0
mov cx,40
mov dx,40
call 2b7 ;scalesprite
;
;
mov dl,0
mov di,1100
call 20c ;fillimage (set dl=color di=image struct pointer)
;
; procedure delay     116                ax=delay
;
mov ax,40
push ds
mov bx,040 ;BIOS data seg
mov ds,bx
mov bx,[6C] ;lowtimer
mov dx,bx
add dx,ax
;@loop  f66
mov bx,[6C] ;lowtimer
cmp bx,dx
jb f66 ;@loop
pop ds
;
;
;******************* letzgo' ********
;
;
;**** INTRO; CREDITS *****
call c9c ;CREDITS
;
;
;*** INTRO : KELTH***
finit
 fldz
 fst tbyte ptr [1158] ;tb
wait
finit
 fldz
 fst tbyte ptr [11a8] ;tb10
wait
call 7b9  ;KELTH MUTER
;
;
;
;
;*** INTRO : SMILY 1***
finit
 fldz
 fst tbyte ptr [1158] ;tb
wait
finit
 fldz
 fst tbyte ptr [11a8] ;tb10
wait
mov ax,1
mov [1112],ax   ;ww
call 84b  ;smile effect 1
;
;
;** INTRO: FIRE**
call b04
;
;*** INTRO : SMILY 2***
finit
 fldz
 fst tbyte ptr [1158] ;tb
wait
finit
 fldz
 fst tbyte ptr [11a8] ;tb10
wait
mov ax,2
mov [1112],ax   ;ww
call 84b  ;smile effect 2
;
;**** INTRO: CRYING HART****
;
call b7d
;
;
;
;
;
;cs:fc3
call 107b
;
;
;
;
;
;
;******************* stop! **********
;
;inittextmode
MOV     AX,0003
INT     10
;dealocate mem
;Vscreen.segment
mov es,[110c]
xor ax,ax
mov ah,49
int 21
;temp screen.segment
mov es,[2466]
xor ax,ax
mov ah,49
int 21
; program exit
int 20
;
;
;
;
;
;*********************** HART *********************
;DEPACK HART fe1
;DECODE & MAKE SPRITE
;
;
;
;
;
;
;
;
;
;
;
;
xor bx,bx
xor si,si
push ds
push cs
pop ds
; @MainLoop: fe8
;
mov di,si
add di,109d ; offset Herzdata
mov al,[di] ; get packeed pixel
mov bl,al
;
push si
mov di,1cc6            ; herzspritedata
shl si,1
shl si,1
shl si,1
add di,si
pop si
;
;
;
;
mov cl,7
shl al,cl
shr al,cl
;
mov [di],al ;col1
;
mov al,bl
;
;
mov cl,1
shr al,cl
;
mov cl,7
shl al,cl
shr al,cl
;
inc di
mov [di],al ;col2
;
mov al,bl
;
;
mov cl,2
shr al,cl
;
mov cl,7
shl al,cl
shr al,cl
;
;
;
;
;
;
;
;
inc di
mov [di],al ; col 3
mov al,bl
;
;
;
mov cl,3
shr al,cl
;
mov cl,7
shl al,cl
shr al,cl
;
;
;
inc di
mov [di],al ;col4
mov al,bl
;
;
;
mov cl,4
shr al,cl
;
mov cl,7
shl al,cl
shr al,cl
;
;
;
inc di
mov [di],al ;col5
mov al,bl
;
;
;
mov cl,5
shr al,cl
;
mov cl,7
shl al,cl
shr al,cl
;
inc di
mov [di],al ;col6
mov al,bl
;
;
;
;
mov cl,6
shr al,cl
;
mov cl,7
shl al,cl
shr al,cl
;
inc di
mov [di],al ;col7
mov al,bl
;
;
;
;
mov cl,7
shr al,cl
;
mov cl,7
shl al,cl
shr al,cl
;
;
;
;
inc di
mov [di],al ; col8
;
;
;
;
;
;
;
;
;
inc si
;
;
;
;
;
;
;
;
;
;
;
;
;
;
cmp si,42
jae 1079    ;@MainLoopExit
jmp fe8      ;@MainLoop
;@MainLoopExit:   1079
;
;
;
;
pop ds
;
;
;
;
;
;
ret
;
;
;*********************************************************************
;******************  cs:107b   END SMILY *****************************
;*********************************************************************
Mov dl,0
mov di,1100
call 20c ; fillimage (set dl=color di=image struct pointer)
;
xor ax,ax
;@SetUP PAL - UP  843
inc al     ;col
mov ah,al  ;col7 ;r
mov bl,al  ;col7 ;g
mov bh,al  ;col7 ;b
db 60
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
db 61
cmp al,40
jnz 843;@Setup - UP 843
;
;@SetUP PAL - down   854
dec al     ;col
mov ah,al  ;col7 ;r
mov bl,al  ;col7 ;g
mov bh,al  ;col7 ;b
db 60
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
db 61
cmp al,0
jnz 854;@Setup - down 854
;
mov al,40
;@SetUP PAL - rest  867
inc al     ;col
mov ah,0  ;col7 ;r
mov bl,0  ;col7 ;g
mov bh,0  ;col7 ;b
db 60
call 22a ;write to pal (set al=numcol;ah=r;bl=g;bh=b)
db 61
cmp al,ff
jnz 867;@Setup - rest 867
;
;
;
mov ax,[1112] ;ww
cmp ax,1
jz 885  ;@mode1
cmp ax,2
jz 88a  ;@mode2
;
;@mode1  885
mov dx,-50
jmp 88d ;@go
;@mode2  88a
mov dx,147
;@go   88d
;
;*****  MAIN LOOP **** ***    88d
;
db 60
;
Mov dl,0
mov di,111a  ;tempscreen
call 20c ; fillimage (set dl=color di=image struct pointer)
Mov dl,0
mov di,1108  ;vscreen
call 20c ; fillimage (set dl=color di=image struct pointer)
;
; draw lines 1
xor ax,ax
mov bx,140
xor cx,cx
;@l1 8a5
inc cx
mov dx,cx
mov di,1108     ;vscreen
db 60
add cx,24
call 259 ;hLine (set ax=x1 bx=x2 cx=y dx=color di=image struct pointer)
db 61
cmp cx,40
jb 8a5 ;@l1
;
; draw lines 2
xor ax,ax
mov bx,140
mov cx,3f
mov dx,cx
;@l2 8c2
inc cx
dec dx
mov di,1108     ;vscreen
db 60
add cx,24
call 259 ;hLine (set ax=x1 bx=x2 cx=y dx=color di=image struct pointer)
db 61
cmp cx,80
jb 8c2 ;@l2
ret
;
;
;
;












;
;
;
;
;
;
;
;
;
;
; ************** OUR DATA ***********
;109d
 db 70
 db 0
 db E
 db F8
 db 1
 db 1F
 db FC
 db 83
 db 3F
 db FE
 db C7
 db 7F
 db FE
 db EF
 db 7F
 db FF
 db EF
 db FF
 db FF
 db FF
 db FF
 db FF
 db FF
 db FF
 db FF
 db FF
 db FF
 db FF
 db FF
 db FF
 db FE
 db FF
 db 7F
 db FE
 db FF
 db 7F
 db FC
 db FF
 db 3F
 db F8
 db FF
 db 1F
 db F0
 db FF
 db F
 db E0
 db FF
 db 7
 db C0
 db FF
 db 3
 db 80
 db FF
 db 1
 db 0
 db FF
 db 0
 db 0
 db 7E
 db 0
 db 0
 db 3C
 db 0
 db 0
 db 18
 db 0
;
;
;
;
;
;
;cs:10df
db '"PSYCH 66"'
db 'Code: Key-Real',d,a
db 1,2,3,4
db ':)'
db '$'
;cs:1100
