#version 130
uniform float scale;
uniform sampler2D textureMap;

void main (void)
{
  vec2 texCoord = gl_FragCoord.xy / textureSize(textureMap,0);

  const float bloomThreshold = .5;
  vec4 color = texture2D(textureMap, texCoord * scale);
  
  if ( color.r > bloomThreshold || color.g > bloomThreshold || color.b > bloomThreshold )
	gl_FragColor = color;
  else
	gl_FragColor = vec4(0.0);
}
