kernel void particle2(global float4 *in, global float4 *pos, int numPoints, int run)
{
	int i = get_global_id(0);
	
	float4 v[8];
	float  len[8];
	
	if (run == 0)
	{
		for(int j=0; j < 8; j++)
		{
			v[j] = pos[j] - in[i+numPoints];
			len[j] = length(v[j]) - 1000.0f;
		}
	}
	else
	{
		for(int j=0; j < 8; j++)
		{
			v[j] = pos[j] - in[i];
			len[j] = length(v[j]) - 1000.0f;
		}
	}
	
	float force = len[0]*len[1]*len[2]*len[3]*len[4]*len[5]*len[6]*len[7] / 1e23f;
	float4 dir = (float4)(0.0f);

	for(int j=0; j < 8; j++)	
		dir += normalize(v[j]);
		
	if (run == 0)
		in[i] = in[i+numPoints] + dir * force;
	else
		in[i] += dir * force;

}