/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.postfx;

import ch.bildspur.postfx.Supervisor;
import ch.bildspur.postfx.pass.Pass;
import java.nio.file.Path;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix3D;

public class PostFXSupervisor
implements Supervisor {
    private PApplet sketch;
    private final int PASS_NUMBER = 2;
    private int width;
    private int height;
    private int[] resolution = new int[2];
    private Path shaderPath;
    private int passIndex = -1;
    private PGraphics[] passBuffers;
    private final PMatrix3D originalMatrix;

    public PostFXSupervisor(PApplet sketch) {
        this(sketch, sketch.width, sketch.height);
    }

    public PostFXSupervisor(PApplet sketch, int width, int height) {
        this.sketch = sketch;
        this.setResolution(width, height);
        this.originalMatrix = sketch.g.is3D() ? sketch.getMatrix((PMatrix3D)null) : new PMatrix3D();
    }

    private void increasePass() {
        this.passIndex = (this.passIndex + 1) % this.passBuffers.length;
    }

    @Override
    public void setResolution(int width, int height) {
        this.width = width;
        this.height = height;
        this.passBuffers = new PGraphics[2];
        for (int i = 0; i < this.passBuffers.length; ++i) {
            this.passBuffers[i] = this.sketch.createGraphics(width, height, "processing.opengl.PGraphics2D");
            this.passBuffers[i].noSmooth();
        }
        this.resolution = new int[]{width, height};
    }

    @Override
    public int[] getResolution() {
        return this.resolution;
    }

    public void render() {
        this.sketch.g.endDraw();
        this.render(this.sketch.g);
        this.sketch.g.beginDraw();
    }

    @Override
    public void render(PGraphics graphics) {
        PGraphics pass = this.getNextPass();
        this.clearPass(pass);
        pass.beginDraw();
        pass.image((PImage)graphics, 0.0f, 0.0f);
        pass.endDraw();
        this.increasePass();
    }

    @Override
    public void pass(Pass pass) {
        pass.prepare(this);
        pass.apply(this);
        this.increasePass();
    }

    public void compose() {
        if (this.sketch.g.is3D()) {
            this.beginHUD();
        }
        this.sketch.g.image((PImage)this.getCurrentPass(), 0.0f, 0.0f);
        if (this.sketch.g.is3D()) {
            this.endHUD();
        }
    }

    @Override
    public void compose(PGraphics graphics) {
        this.clearPass(graphics);
        graphics.beginDraw();
        graphics.image((PImage)this.getCurrentPass(), 0.0f, 0.0f);
        graphics.endDraw();
    }

    @Override
    public PGraphics getNextPass() {
        int nextIndex = (this.passIndex + 1) % this.passBuffers.length;
        return this.passBuffers[nextIndex];
    }

    @Override
    public PGraphics getCurrentPass() {
        return this.passBuffers[this.passIndex];
    }

    @Override
    public void clearPass(PGraphics pass) {
        pass.beginDraw();
        pass.background(0, 0.0f);
        pass.resetShader();
        pass.endDraw();
    }

    private void beginHUD() {
        this.sketch.g.pushMatrix();
        this.sketch.g.hint(2);
        this.sketch.g.resetMatrix();
        this.sketch.g.applyMatrix(this.originalMatrix);
    }

    private void endHUD() {
        this.sketch.g.hint(-2);
        this.sketch.g.popMatrix();
    }
}

