/*
 * Decompiled with CFR 0.152.
 */
package cml.math;

public class Matrix {
    private int columns;
    private int rows;
    private double[] entries;

    public Matrix(int n, int n2, double[] dArray) {
        if (n * n2 != dArray.length) {
            throw new RuntimeException("Invalid number of entries");
        }
        this.columns = n2;
        this.rows = n;
        this.entries = dArray;
    }

    protected Matrix(Matrix matrix) {
        this.columns = matrix.columns;
        this.rows = matrix.rows;
        this.entries = (double[])matrix.entries.clone();
    }

    public double get(int n, int n2) {
        return this.entries[n * this.columns + n2];
    }

    protected void set(int n, int n2, double d) {
        this.entries[n * this.columns + n2] = d;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    private void RowMul(int n, double d, int n2) {
        for (int i = n2; i < this.columns; ++i) {
            this.set(n, i, d * this.get(n, i));
        }
    }

    private void RowSubMul(int n, int n2, double d, int n3) {
        for (int i = n3; i < this.columns; ++i) {
            this.set(n, i, this.get(n, i) - d * this.get(n2, i));
        }
    }

    private void SwapRows(int n, int n2, int n3) {
        for (int i = n3; i < this.columns; ++i) {
            double d = this.get(n, i);
            this.set(n, i, this.get(n2, i));
            this.set(n2, i, d);
        }
    }

    public Matrix solve() {
        Matrix matrix = new Matrix(this);
        matrix.internalSolve();
        return matrix;
    }

    private Solution internalSolve() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.columns - 1 && n4 < this.rows; ++n3) {
            for (n2 = n4; this.get(n2, n3) == 0.0 && n2 < this.rows; ++n2) {
            }
            if (n2 == this.rows) continue;
            if (n2 != n4) {
                this.SwapRows(n4, n2, n3);
            }
            this.RowMul(n4, 1.0 / this.get(n4, n3), n3 + 1);
            this.set(n4, n3, 1.0);
            for (n = n4 + 1; n < this.rows; ++n) {
                if (this.get(n, n3) == 0.0) continue;
                this.RowSubMul(n, n4, this.get(n, n3), n3 + 1);
                this.set(n, n3, 0.0);
            }
            ++n4;
        }
        for (n3 = n4; n3 < this.rows; ++n3) {
            if (this.get(n3, this.rows - 1) == 0.0) continue;
            return Solution.NO_SOLUTION;
        }
        n3 = this.columns - 1;
        for (n2 = n4 - 1; n2 > 0; --n2) {
            n3 = 0;
            while (this.get(n2, n3) == 0.0) {
                ++n3;
            }
            for (n = 0; n < n2; ++n) {
                this.set(n, this.columns - 1, this.get(n, this.columns - 1) - this.get(n, n3) * this.get(n2, this.columns - 1));
                this.set(n, n3, 0.0);
            }
        }
        if (n4 >= this.rows - 1) {
            return Solution.ONE_SOLUTION;
        }
        return Solution.INF_SOLUTIONS;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rows; ++i) {
            stringBuffer.append("[");
            for (int j = 0; j < this.columns; ++j) {
                stringBuffer.append(this.get(i, j));
                if (j == this.columns - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]\n");
        }
        return stringBuffer.toString();
    }

    static enum Solution {
        NO_SOLUTION,
        ONE_SOLUTION,
        INF_SOLUTIONS;

    }
}

