/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.libraries;

import cml.kickass.constant.Constant;
import cml.kickass.exceptions.AsmError;
import cml.kickass.function.DoubleFunction;
import cml.kickass.function.DoubleX2Function;
import cml.kickass.function.Function;
import cml.kickass.function.LongFunction;
import cml.kickass.function.LongX2DebugFunction;
import cml.kickass.function.VoidFunction;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.libraries.Library;
import cml.kickass.values.NullValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class MathLibrary
implements Library {
    private static Random randomGenerator = new Random(0L);

    public static void setSeed(long l) {
        randomGenerator.setSeed(l);
    }

    public static Random getRandomGenerator() {
        return randomGenerator;
    }

    public List<Constant> getConstants() {
        ArrayList<Constant> arrayList = new ArrayList<Constant>();
        arrayList.add(new Constant("PI", new NumberValue(Math.PI)));
        arrayList.add(new Constant("E", new NumberValue(Math.E)));
        return arrayList;
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new DoubleFunction("abs", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.abs(d));
            }
        });
        arrayList.add(new DoubleFunction("acos", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.acos(d));
            }
        });
        arrayList.add(new DoubleFunction("asin", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.asin(d));
            }
        });
        arrayList.add(new DoubleFunction("atan", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.atan(d));
            }
        });
        arrayList.add(new DoubleX2Function("atan2", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d, double d2) {
                return new NumberValue(Math.atan2(d, d2));
            }
        });
        arrayList.add(new DoubleFunction("cbrt", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.cbrt(d));
            }
        });
        arrayList.add(new DoubleFunction("ceil", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.ceil(d));
            }
        });
        arrayList.add(new DoubleFunction("cos", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.cos(d));
            }
        });
        arrayList.add(new DoubleFunction("cosh", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.cosh(d));
            }
        });
        arrayList.add(new DoubleFunction("exp", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.exp(d));
            }
        });
        arrayList.add(new DoubleFunction("expm1", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.expm1(d));
            }
        });
        arrayList.add(new DoubleFunction("floor", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.floor(d));
            }
        });
        arrayList.add(new DoubleX2Function("hypot", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d, double d2) {
                return new NumberValue(Math.hypot(d, d2));
            }
        });
        arrayList.add(new DoubleX2Function("IEEEremainder", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d, double d2) {
                return new NumberValue(Math.IEEEremainder(d, d2));
            }
        });
        arrayList.add(new DoubleFunction("log", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.log(d));
            }
        });
        arrayList.add(new DoubleFunction("log10", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.log10(d));
            }
        });
        arrayList.add(new DoubleFunction("log1p", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.log1p(d));
            }
        });
        arrayList.add(new DoubleX2Function("max", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d, double d2) {
                return new NumberValue(Math.max(d, d2));
            }
        });
        arrayList.add(new DoubleX2Function("min", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d, double d2) {
                return new NumberValue(Math.min(d, d2));
            }
        });
        arrayList.add(new DoubleX2Function("pow", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d, double d2) {
                return new NumberValue(Math.pow(d, d2));
            }
        });
        arrayList.add(new VoidFunction("random", (Value)NumberValue.invalid){

            @Override
            protected Value f() {
                return new NumberValue(randomGenerator.nextDouble());
            }
        });
        arrayList.add(new DoubleFunction("round", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.round(d));
            }
        });
        arrayList.add(new DoubleFunction("signum", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.signum(d));
            }
        });
        arrayList.add(new DoubleFunction("sin", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.sin(d));
            }
        });
        arrayList.add(new DoubleFunction("sinh", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.sinh(d));
            }
        });
        arrayList.add(new DoubleFunction("sqrt", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.sqrt(d));
            }
        });
        arrayList.add(new DoubleFunction("tan", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.tan(d));
            }
        });
        arrayList.add(new DoubleFunction("tanh", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.tanh(d));
            }
        });
        arrayList.add(new DoubleFunction("toDegrees", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.toDegrees(d));
            }
        });
        arrayList.add(new DoubleFunction("toRadians", (Value)NumberValue.invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(Math.toRadians(d));
            }
        });
        arrayList.add(new LongX2DebugFunction("mod", (Value)NumberValue.invalid){

            @Override
            protected Value f(long l, long l2, DebugInfo debugInfo) {
                if (l2 == 0L) {
                    throw new AsmError("The second argument of the mod function cant be zero", debugInfo);
                }
                return new NumberValue(l % l2);
            }
        });
        arrayList.add(new LongFunction("setSeed", (Value)NullValue.instance){

            @Override
            protected Value f(long l) {
                randomGenerator.setSeed(l);
                return NullValue.instance;
            }
        });
        return arrayList;
    }
}

