/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.Value;

public class ShorCircuitedOperatorCall
extends ExprNode {
    private String functionName;
    private Operator operator;
    private ExprNode arg1Expr;
    private ExprNode arg2Expr;

    public ShorCircuitedOperatorCall(String string, DebugInfo debugInfo, ExprNode exprNode, ExprNode exprNode2) {
        super(debugInfo);
        this.functionName = string;
        this.arg1Expr = exprNode;
        this.arg2Expr = exprNode2;
        if (string.equals("&&")) {
            this.operator = Operator.and;
        } else if (string.equals("||")) {
            this.operator = Operator.or;
        } else {
            throw new AsmError("Unknow operator " + (Object)((Object)this.operator), debugInfo);
        }
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        boolean bl;
        Value value = this.arg1Expr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return BooleanValue.invalid;
        }
        boolean bl2 = value.getBoolean(this.debug);
        if (this.operator == Operator.and && !bl2) {
            return BooleanValue.falseValue;
        }
        if (this.operator == Operator.or && bl2) {
            return BooleanValue.trueValue;
        }
        Value value2 = this.arg2Expr.evaluate(evaluationState);
        if (value2.isInvalid()) {
            return BooleanValue.invalid;
        }
        boolean bl3 = value2.getBoolean(this.debug);
        if (this.operator == Operator.and) {
            bl = bl2 && bl3;
        } else if (this.operator == Operator.or) {
            bl = bl2 || bl3;
        } else {
            throw new AsmError("Unknow operator " + (Object)((Object)this.operator), this.debug);
        }
        return BooleanValue.get(bl);
    }

    public String toString() {
        return this.functionName;
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        exprTreeBuilder.addNode("ShortCircuitOperator", this.functionName, this.arg1Expr, this.arg2Expr);
        return exprTreeBuilder;
    }

    public static enum Operator {
        and,
        or;

    }
}

