/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.asmnode.output.reciever.CodeCollectorOutputReciever;
import cml.kickass.asmnode.output.reciever.MainOutputReciever;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.asmnode.output.reciever.OutputStreamType;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.MemoryBlock;
import cml.kickass.plugins.impl.PluginEngine;
import cml.kickass.plugins.impl.PluginValue;
import cml.kickass.plugins.interf.IMemoryBlock;
import cml.kickass.plugins.interf.IModifier;
import cml.kickass.plugins.interf.IValue;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.List;

public class ModifyDirective
extends AsmDirective {
    private String name;
    private List<ExprNode> argumentExprs;
    private AsmNode body;
    private boolean isFinished = false;
    private FunctionSideOutput sideOutputFromArguments;
    private byte[] modifiedBytes;

    public ModifyDirective(String string, List<ExprNode> list, AsmNode asmNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
        this.argumentExprs = list;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new ModifyDirective(this.name, this.argumentExprs, this.body.copy(), this.debug);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        Object object;
        evaluationState.clearFunctionSideOutput();
        boolean bl = false;
        IValue[] iValueArray = new IValue[this.argumentExprs.size()];
        for (int i = 0; i < iValueArray.length; ++i) {
            object = this.argumentExprs.get(i).evaluate(evaluationState);
            bl |= ((Value)object).isInvalid();
            iValueArray[i] = new PluginValue((Value)object, this.debug);
        }
        this.sideOutputFromArguments = evaluationState.getFunctionSideOutput();
        Integer n = evaluationState.getMemoryPosition();
        evaluationState.setMemoryPosition(8192);
        this.body = this.body.parse(evaluationState);
        evaluationState.setMemoryPosition(null);
        if (bl || !this.body.isFinished()) {
            return this;
        }
        if (this.modifiedBytes == null) {
            object = new CodeCollectorOutputReciever(8192, evaluationState.getMaxMemoryAddress());
            this.body.deliverOutput((OutputReciever)object);
            List<MemoryBlock> list = ((MainOutputReciever)object).getMemoryBlocks();
            ArrayList<IMemoryBlock> arrayList = new ArrayList<IMemoryBlock>();
            for (MemoryBlock object22 : list) {
                if (object22.isVirtual()) continue;
                arrayList.add(object22.getPluginMemoryBlock());
            }
            IModifier iModifier = evaluationState.getSystemScope().getModifierPlugins().get(this.name);
            if (iModifier == null) {
                throw new AsmError("Unknown modifyer: " + this.name, this.debug);
            }
            PluginEngine pluginEngine = new PluginEngine(evaluationState, this.debug);
            this.modifiedBytes = iModifier.execute(arrayList, iValueArray, pluginEngine);
        }
        object = n == null ? null : Integer.valueOf(n + this.modifiedBytes.length);
        evaluationState.setMemoryPosition((Integer)object);
        this.isFinished = true;
        return this;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        new SideEffectOnlyOutput(this.sideOutputFromArguments).deliverOutput(outputReciever);
        this.body.deliverOutput(new ByteOutputFilter(outputReciever));
        outputReciever.addAssembledBytes(this.modifiedBytes);
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        return null;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        this.body.preParse(evaluationState);
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        this.body.registerMetaDefinitions(evaluationState);
        return this;
    }

    static class ByteOutputFilter
    implements OutputReciever {
        private OutputReciever reciever;

        public ByteOutputFilter(OutputReciever outputReciever) {
            this.reciever = outputReciever;
        }

        @Override
        public void addToStream(OutputStreamType outputStreamType, String string, Object object) {
            this.reciever.addToStream(outputStreamType, string, object);
        }

        @Override
        public void addAssembledBytes(byte[] byArray) {
        }

        @Override
        public void startNewMemoryBlock(int n, String string, boolean bl) {
        }

        @Override
        public List<MemoryBlock> getMemoryBlocks() {
            return this.reciever.getMemoryBlocks();
        }
    }
}

