#ifndef _MESH_HPP_
#define _MESH_HPP_

//#include "Vector.hpp"
#include "externs.hpp"

class Face
{
public:
	int v1, v2, v3; //indeksit verteksitaulukkoon
	Vector normal;
};

class Vertex
{
public:

	Vector position;
    Vector position2;
	Vector normal;
	Vector color;
	float u, v;
};

class TexCoord
{
public:
    float u;
    float v;


};

class Edge
{
public:
	int v1;
	int v2;
};

class Mesh
{
public:
    Mesh();
    ~Mesh();

    //aksessorit
	Vector *getVertices() { return vertices; }
	Vector *getNormals() { return normals; }
	Face *getFaces() { return faces; }
	Edge *getEdges() { return edges; }
	TexCoord *getUV() { return uv; }

    int getVertexCount() { return vertexcount; }
	int getFaceCount() { return facecount; }
	int getEdgeCount() { return edgecount; }
        
    //piirto
    //tarttee keksi nihin joku fiksumpi
    void drawTextured();
	void drawTexturedWithLight(Vector &light, Vector &color, float ambient);
    void drawSolidColor();
    void drawSolidColorWithLight(Vector &light, Vector &color, float ambient);

    //inittijutut
    void calculateNormals(); //rikkoo pallon normaalit - investigate
    void makeFaces(int xres, int yres); //linkitt tason faceihin
    void scale(float max); //skaalaa mallin niin, ett kauimpana keskustasta olevan verteksin etisyys on max

    //TODO: kunnolliset mappaukset :)
    void makeUVBox(float scale);  //u = x, v = y
    void makeUVSphere(float scale); //envymap

    //rakentaa mallin
    void buildSphere(float radius, int xres, int yres, float texturescale=1.0f);
	void buildPlane(float size, int xres, int yres, Vector &rotation);
    void buildTorus(float radius1, float radius2, int xres, int yres);
    void buildEmpty(int xres, int yres);
    void buildAsteroid(int seed, int xres, int yres, float size, float texturescale);
    void buildAsteroid2(int seed, int xres, int yres, float size, float texturescale);
	void emptyCopy(Mesh *object);

	void destroy();


    int vertexcount;
    int facecount;
    int edgecount;

    Vector *vertices;
    Vector *normals;
    Vector *colors;
    TexCoord *uv;
    
    Face *faces;
	Edge *edges;



};


#endif
