#ifndef _VertexBUFFER_HPP_
#define _VertexBUFFER_HPP_

#include "externs.hpp"

class FloatContainer
{
public:
    float value;
};

class Vertexbuffer
{
public:

    Vertexbuffer();
    ~Vertexbuffer();

    void startVertices();
    void startUV();
    void startNormals();
    void startColors();

    void addUV(float u, float v);
    void addVertex(Vector3 &vertex);
    void addNormal(Vector3 &normal);
    void addColor(Vector3 &colors);

    void finalize();

    const int getVertexCount() { return this->vertexcount; };
    const int getQuadCount() { return this->vertexcount / 4; };
    const int getTriangleCount() { return this->vertexcount / 3; };
    Vector3 *getVertexBuffer() { return this->vertices; };
    Vector3 *getNormalBuffer() { return this->normals; };
    Vector3 *getColorBuffer() { return this->colors; };
    float *getUVBuffer() { return this->uv; };

    Lista2 *getVertexList() { return this->vertexlist; };
    Lista2 *getUList() { return this->ulist; };
    Lista2 *getVList() { return this->vlist; };
    Lista2 *getNormalList() { return this->normallist; };
    Lista2 *getColorList() { return this->colorlist; };

private:
    void finalizeUV();
    void finalizeVertices();
    void finalizeNormals();
    void finalizeColors();

    Lista2 *vertexlist;
    Lista2 *normallist;
    Lista2 *colorlist;
    Lista2 *ulist;
    Lista2 *vlist;

    Vector3 *vertices;
    Vector3 *normals;
    Vector3 *colors;
    float *uv;
    int vertexcount;

    bool containsVertices;
    bool containsUV;
    bool containsNormals;
    bool containsColors;


};

#endif