#include "Vertexbuffer.hpp"

Vertexbuffer::Vertexbuffer()
{
    containsVertices = false;
    containsUV = false;
    containsNormals = false;
    containsColors = false;
}

Vertexbuffer::~Vertexbuffer()
{
    if (containsVertices)
        delete [] vertices;
    if (containsUV)
        delete [] uv;
    if (containsNormals)
        delete [] normals;
    if (containsColors)
        delete [] colors;
}

void Vertexbuffer::startVertices()
{
    this->vertexlist = new Lista2();
    this->vertexcount = 0;
    containsVertices = true;
}
void Vertexbuffer::startNormals()
{
    this->normallist = new Lista2();
    containsNormals = true;
}
void Vertexbuffer::startColors()
{
    this->colorlist = new Lista2();
    containsColors = true;
}
void Vertexbuffer::startUV()
{
    this->ulist = new Lista2();
    this->vlist = new Lista2();
    containsUV = true;
}

void Vertexbuffer::addUV(float u, float v)
{
    FloatContainer *ucont = new FloatContainer();
    FloatContainer *vcont = new FloatContainer();

    ucont->value = u;
    vcont->value = v;

    ulist->add(ucont);
    vlist->add(vcont);
}

void Vertexbuffer::addVertex(Vector3 &vertex)
{
    Vector3 *vert = new Vector3(vertex.x, vertex.y, vertex.z);
    this->vertexlist->add(vert);
}
void Vertexbuffer::addNormal(Vector3 &normal)
{
    Vector3 *n = new Vector3(normal.x, normal.y, normal.z);
    this->normallist->add(n);
}
void Vertexbuffer::addColor(Vector3 &color)
{
    Vector3 *c = new Vector3(color.x, color.y, color.z);
    //c->a = color.a;
    this->colorlist->add(c);
}

void Vertexbuffer::finalize()
{
    if (containsVertices)
        finalizeVertices();

    if (containsUV)
        finalizeUV();

    if (containsNormals)
        finalizeNormals();

    if (containsColors)
        finalizeColors();

}

void Vertexbuffer::finalizeVertices()
{
    int i;
    this->vertexlist->goToStart();
    int count = this->vertexlist->getNodeCount();

    this->vertexcount = count;

    vertices = new Vector3[count];
    for (i=0;i<count;i++)
    {
        vertices[i] = *(Vector3 *) this->vertexlist->getCurrent();
        this->vertexlist->goForward();
    }

    delete this->vertexlist;
}

void Vertexbuffer::finalizeUV()
{
    int i;

    this->ulist->goToStart();
    this->vlist->goToStart();

    int count = this->ulist->getNodeCount();
    this->uv = new float[count*2]; //sek u ett v

    int offs = 0;
    for (i=0;i<count;i++)
    {
        FloatContainer *c1 = (FloatContainer *)ulist->getCurrent();
        FloatContainer *c2 = (FloatContainer *)vlist->getCurrent();
        this->uv[offs++] = c1->value;
        this->uv[offs++] = c2->value;

        ulist->goForward();
        vlist->goForward();
    }
    delete this->ulist;
    delete this->vlist;
}

void Vertexbuffer::finalizeNormals()
{
    int i;
    this->normallist->goToStart();
    int count = this->normallist->getNodeCount();

    normals = new Vector3[count];
    for (i=0;i<count;i++)
    {
        normals[i] = *(Vector3 *) this->normallist->getCurrent();
        this->normallist->goForward();
    }

    delete this->normallist;
}

void Vertexbuffer::finalizeColors()
{
    int i;
    this->colorlist->goToStart();
    int count = this->colorlist->getNodeCount();

    colors = new Vector3[count];
    for (i=0;i<count;i++)
    {
        colors[i] = *(Vector3 *) this->colorlist->getCurrent();
        this->colorlist->goForward();
    }

    delete this->colorlist;
}
