#ifndef _POSTPROC_HPP_
#define _POSTPROC_HPP_

#include "externs.hpp"

extern class PostProc filter;

class PostProc
{
public:

	// Call this before rendering stuff that needs postprocession
	void init(bool clear=true);
	
	// Call this before rendering stuff that needs DOF post procession
	void initDOF(bool clear=true);

	// near & far = edge of full blur, focus = no blur
	void dof(float nearDist=5.0f, float focusDist=10.0f, float farDist=25.0f, int blur_steps=5, float blur_step_x=0.0006f, float blur_step_y=0.006f);

	// Call this when you want render the glow the screen [darken_alpha -1 = no darken at all]
	void glow(int blur_steps=5, float blur_step_x=0.006f, float blur_step_y=0.006f, float blur_brightness=1.0f, float darken_alpha=-1.0f, float glow_amount=1.0f);

	// Renders blurred scene with given parameters
	void blur(int blur_steps=5, float blur_step_x=0.004f, float blur_step_y=0.004f);

	// Renders edgedetection filter
	void edge(int blur_steps=3, float blur_step_x=0.002f, float blur_step_y=0.002f, float blur_alpha=1.0f);

	// Draws overlay on top of everything
	void drawOverlay(GLuint &texid);

protected:
};


#endif