#ifndef _KEWLERSYSTEM_HPP_
#define _KEWLERSYSTEM_HPP_

#include "externs.hpp"
#include "mathematics.hpp"

class KewlerSystem
{
public:
    KewlerSystem();
    ~KewlerSystem();
    KewlerSystem(int maxcount);

    void addKewler(Vector3 point, float size, float alpha);

    void renderTest();

    void startFrame();
    void endFrame();

private:
    int count;
    int vertexoffset;
    int coloroffset;
    int indexoffset;
    int uvoffset;
    int maxcount;
    float *colorbuffer;
    float *uvbuffer;
    unsigned int *indexbuffer;
    Vector3 *vertexbuffer;

    Vector3 xt, yt, zt;
    Vector3 disp1, disp2, disp3, disp4;



};

#endif
