#include "kewlersystem.hpp"

KewlerSystem::KewlerSystem()
{
	vertexbuffer = 0;
    colorbuffer = 0;
    uvbuffer = 0;
	indexbuffer = 0;
}

KewlerSystem::~KewlerSystem()
{

    if (colorbuffer != 0)
    {
        delete [] colorbuffer;
    }
    if (uvbuffer != 0)
    {
        delete [] uvbuffer;
    }
    if (indexbuffer != 0)
    {
        delete [] indexbuffer;
    }
    if (vertexbuffer != 0)
    {
        delete [] vertexbuffer;
    }

    vertexbuffer = 0;
    colorbuffer = 0;
    uvbuffer = 0;
	indexbuffer = 0;

}

KewlerSystem::KewlerSystem(int maxcount)
{
	if (maxcount<0)
    {
        maxcount = 100;
    }
    this->maxcount = maxcount;
    colorbuffer		= new float[maxcount * 4 * 4]; //r, g, b, a per vertx
    uvbuffer		= new float[maxcount * 4 * 2]; // u, v per vertex
    indexbuffer		= new unsigned int [maxcount * 3 * 2]; //three vertices per triangle, two triangles per kewler
    vertexbuffer	= new Vector3[maxcount * 4];
}

void KewlerSystem::addKewler(Vector3 point, float size, float alpha)
{
    vertexbuffer[vertexoffset++] = point - (this->xt + this->yt) * size;
    vertexbuffer[vertexoffset++] = point + (this->xt - this->yt) * size;
    vertexbuffer[vertexoffset++] = point + (this->xt + this->yt) * size;
    vertexbuffer[vertexoffset++] = point - (this->xt - this->yt) * size;

    //
    indexbuffer[indexoffset++] = vertexoffset - 4; //eka
    indexbuffer[indexoffset++] = vertexoffset - 3; //toka
    indexbuffer[indexoffset++] = vertexoffset - 1; //vika
    indexbuffer[indexoffset++] = vertexoffset - 3; //toka
    indexbuffer[indexoffset++] = vertexoffset - 2; //kolmas
    indexbuffer[indexoffset++] = vertexoffset - 1; //vika

    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = alpha;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = alpha;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = alpha;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = 1.0f;
    colorbuffer[coloroffset++] = alpha;

    uvbuffer[uvoffset++] = 0.0f;
    uvbuffer[uvoffset++] = 0.0f;
    uvbuffer[uvoffset++] = 1.0f;
    uvbuffer[uvoffset++] = 0.0f;
    uvbuffer[uvoffset++] = 1.0f;
    uvbuffer[uvoffset++] = 1.0f;
    uvbuffer[uvoffset++] = 0.0f;
    uvbuffer[uvoffset++] = 1.0f;

    count++;
}

void KewlerSystem::renderTest()
{
    glDisable(GL_DEPTH_TEST);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glEnable(GL_TEXTURE_2D);
/*
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState( GL_TEXTURE_COORD_ARRAY );
	glEnableClientState( GL_COLOR_ARRAY );
	glDisableClientState( GL_NORMAL_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, vertexbuffer);
    glTexCoordPointer(2, GL_FLOAT, 0, uvbuffer);
    glColorPointer(4, GL_FLOAT, 0, colorbuffer);
	glDrawArrays(GL_QUADS, 0, count * 4);
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState( GL_TEXTURE_COORD_ARRAY );
	glDisableClientState( GL_COLOR_ARRAY );
	glDisableClientState( GL_NORMAL_ARRAY);

/*
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState( GL_TEXTURE_COORD_ARRAY );
	glEnableClientState( GL_COLOR_ARRAY );
	glDisableClientState( GL_NORMAL_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, vertexbuffer);
    glTexCoordPointer(2, GL_FLOAT, 0, uvbuffer);
    glColorPointer(4, GL_FLOAT, 0, colorbuffer);
	glDrawElements(GL_TRIANGLES, count * 3 * 2, GL_UNSIGNED_INT, indexbuffer);
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState( GL_TEXTURE_COORD_ARRAY );
	glDisableClientState( GL_COLOR_ARRAY );
	glDisableClientState( GL_NORMAL_ARRAY);

/*
22:53 <jaw^vvd>           glTexCoordPointer(2,GL_FLOAT,0,mesh->data->vertex_tex_coords.get_pointer());
22:53 <jaw^vvd>           glEnableClientState(GL_TEXTURE_COORD_ARRAY);
22:53 <jaw^vvd>         glVertexPointer(3,GL_FLOAT,0,mesh->data->vertices.get_pointer());
22:53 <jaw^vvd>         glEnableClientState(GL_VERTEX_ARRAY);
22:53 <jaw^vvd>           glDrawElements(GL_TRIANGLES,mesh->data->faces.get_used()*3,GL_UNSIGNED_INT,mesh->data->faces.get_pointer());
22:53 <jaw^vvd>         glDisableClientState(GL_VERTEX_ARRAY);
*/

/*
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glDisable(GL_DEPTH_TEST);

    vertexoffset = 0;
    coloroffset = 0;
    uvoffset = 0;
    for (int i = 0; i < count; i++)
    {
        glBegin(GL_QUADS);
        glTexCoord2fv((float *)&uvbuffer[uvoffset += 2]);
        glColor4fv((float *)&colorbuffer[coloroffset += 4]);
        glVertex3fv((float *)&vertexbuffer[vertexoffset ++]);
        glTexCoord2fv((float *)&uvbuffer[uvoffset += 2]);
        glColor4fv((float *)&colorbuffer[coloroffset += 4]);
        glVertex3fv((float *)&vertexbuffer[vertexoffset ++]);
        glTexCoord2fv((float *)&uvbuffer[uvoffset += 2]);
        glColor4fv((float *)&colorbuffer[coloroffset += 4]);
        glVertex3fv((float *)&vertexbuffer[vertexoffset ++]);
        glTexCoord2fv((float *)&uvbuffer[uvoffset += 2]);
        glColor4fv((float *)&colorbuffer[coloroffset += 4]);
        glVertex3fv((float *)&vertexbuffer[vertexoffset ++]);
        glEnd();

    }
/**/
}

void KewlerSystem::startFrame()
{
    Mathematics::antiRotate(&this->xt, &this->yt, &this->zt);
    vertexoffset = 0;
    coloroffset = 0;
    uvoffset = 0;
    indexoffset = 0;

    count = 0;
}

void KewlerSystem::endFrame()
{
}




