#ifndef _GUIHOLDER_H_
#define _GUIHOLDER_H_

#include <string>
#include "GUIInclude.h"
#include "GUIFont.h"
#include "GUIEvent.h"
#include "GUIElement.h"

class GUIElement;

#include <list>
typedef std::list<GUIElement *> lista;


class GUIHolder 
{
public:
	
	GUIHolder();
   ~GUIHolder();

	void init();
	void deinit();

	int focused; // focused item
	GUIElement *getByCallback(std::string callback); // returns gui element
	void render(float dt);	// render all elements
	std::string processEvent(GUIEvent &e); 	// process events
	void addWidget(GUIElement *e); // add new widget to the list
	void clear(); // clear the list
	void removeByCallback(std::string callback, bool deleteitems=true);

	GUIFont *font;

private:

	GUIElement *mouseTarget;
	lista elements;
	

};

#endif