#ifndef _GUIEVENT_H_
#define _GUIEVENT_H_

#include "GUIInclude.h"

class GUIEvent {
public:
	GUIEvent() { eventtype = GUIUNDEFINED; }
	int eventtype;
};

class GUIKeyboardEvent : public GUIEvent {
public:
	GUIKeyboardEvent(char *key_, bool pressed_, bool shift_) 
	{
		this->key = key_;
		if(strlen(key)==1) this->k = key_[0]; else k=' ';
		this->shift = shift_;
		this->pressed = pressed_;
		this->eventtype = GUIEVENT_KEYBOARDPRESSED;
	}
	char *key;
	char k;
	bool pressed;
	bool shift;
};

class GUIMouseMovedEvent : public GUIEvent {
public:
	GUIMouseMovedEvent(int x, int y)
	{
		this->x = x;
		this->y = y;
		this->eventtype = GUIEVENT_MOUSEMOVED;
	}
	int x,y;
};

class GUIMousePressedEvent : public GUIEvent {
public:
	GUIMousePressedEvent(int x, int y, bool up=false, bool left=true, bool right=false)
	{
		this->x = x;
		this->y = y;
		this->up = up;
		this->left = left;
		this->right = right;
		this->eventtype = GUIEVENT_MOUSEPRESSED;
	}
	
	int x;
	int y;
	bool left, right, up;
};


#endif