#include "GUIToggleButton.h"

GUIToggleButton::GUIToggleButton(int x, int y, int w, int h, const char *callback, const char *label, bool pressed) : 
					   GUIButton(x,y,w,h,callback,label)
{
	this->pressed = pressed;
	this->widgetType = GUITOGGLEBUTTON;

	this->raisable = true;
}


void GUIToggleButton::render(float dt)
{

	this->GUIElement::render(dt);

	glBegin(GL_QUADS);
		glVertex2i(x,	y);
		glVertex2i(x+w,	y);
		glVertex2i(x+w,	y+h);
		glVertex2i(x,	y+h);
	glEnd();

	if(this->pressed)
	{
	 glColor3f(1,1,1);
	 glLineWidth(1);
	 glBegin(GL_LINE_STRIP);
		glVertex2i(x,	y);
		glVertex2i(x+w,	y);
		glVertex2i(x+w,	y+h);
		glVertex2i(x,	y+h);
		glVertex2i(x,	y);
	 glEnd();
	}

	if(holder!=0)
	{
		holder->font->setColor(1,1,1);
		holder->font->printCenteredXY(label.c_str(), x+w/2, y+h/2);
	}
}


std::string GUIToggleButton::checkMousePressedEvents(GUIMousePressedEvent &me) 
{
	if(isHit(me.x, me.y))
	{
		if(me.right==true)
			return "CHANGE_FOCUS_TO_THIS";

		if(me.left==true)
		{
			// jos ei voida nostaa painetaan
			if(this->raisable==false) 
				this->pressed = true;
			else 
				this->pressed = !this->pressed;

			return callback;
		}
		
	}
	return "";
}

std::string GUIToggleButton::checkKeyboardEvents(GUIKeyboardEvent &me)
{
	if(strcmp(me.key,"return")==0)
	{
		if(this->raisable==false) 
			this->pressed = true;
		else 
			this->pressed = !this->pressed;

		return this->callback;
	}

	return "";
}

void GUIToggleButton::setCanBeRaised(bool b)
{
	this->raisable = b;
}