#ifndef _GUISLIDER_H_
#define _GUISLIDER_H_

#define USE_UNSIGNED_CHAR true

#include "GUIInclude.h"
#include "GUIEvent.h"
#include "GUIButton.h"
#include "GUIHolder.h"

class GUIHolder;
class GUIElement;
class GUISlider : public GUIElement
{
public:
	
	GUISlider(int x, int y, int w, int h, const char *callback, float initialvalue, std::string label, int minim=0, int maxim=255);
	
	virtual void render(float dt);
	virtual std::string checkMousePressedEvents(GUIMousePressedEvent &me);
	virtual std::string checkKeyboardEvents(GUIKeyboardEvent &me);	
	virtual std::string checkMouseMovedEvents(GUIMouseMovedEvent &me);// {GUIElement::checkMouseMovedEvents(me); return "";};

	virtual void setLeft(float r,float g, float b);
	virtual void setRight(float r,float g, float b);

	void setSmallAdjustment(int i);
	void setBigAdjustment(int i);

	void setMinimum(int i);
	void setMaximum(int i);
	
	virtual int getValue();
	virtual void setValue(int val);

protected:

	std::string label;
	int scale;
	float left[3];
	float right[3];
	int smallAdjustment;
	int bigAdjustment;
	int minimum;
	int maximum;
};


#endif