#ifndef _Sivuttain_HPP_
#define _Sivuttain_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "../analyzer.hpp"

class SivuttainRunkoSpline
{
public:
    void draw(float pos, float alpha, float sync);
    CatmullRom *curve;
    
    float phase;
    float speed;

    Vector color;
};

class SivuttainTilpe
{
public:

    float st;
    float et;
    void draw(float pos, float alpha, float analval);

    CatmullRom *curve;
    Vector color;
};

class SivuttainParticle
{
public:
    float st;
    float et;

    float size;
    Vector loc;
};

class Spiraali
{
public:

    void draw(float pos, float alpha, float sync);
    float st;
    float et;

    int count;
    Vector color;
    Vector *vertices;

};


class Sivuttain : public Base
{
	public:

		Sivuttain();
		~Sivuttain();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
        Mesh *sky;
        int runkosplinecount;
        int tilpecount;
        int particlecount;
        int spiraalicount;

        SivuttainTilpe **tilpet;
        SivuttainRunkoSpline **rsplinet;
        SivuttainParticle *particlet;
        Spiraali **spiraalit;

        CatmullRom *masterspline;
        Analyzer *anal;

        int pointcount;
        Vector *points;
		void renderScene(float pos, float alpha);

		TriggerSystem *triggers;

};

#endif
