#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "Maasto.hpp"
#include "../library/mathematics.hpp"
#include "../library/primitives.hpp"

void Maasto::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

    filter.init(true);
	renderScene(pos, alpha);
    filter.glow(8, 0.005f, 0.005f, 0.81f, -1.0f, 1.0f);
}

void Maasto::renderScene(float pos, float alpha)
{
    int x, y;
    const float rotspeed = 2;
    Vector3 cam = Vector3(0, 0.54f+pos*0.05f, 0) + Vector3(cosf(pos*rotspeed), 0, sinf(pos*rotspeed))*(0.7f+pos*0.05f);
    Vector3 tgt = Vector3(0, 0, 0);
    Vector3 upw = Vector3(0, 1, 0);

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);

    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_DEPTH_TEST);
    glBegin(GL_QUADS);
    int offset = 0;
    
    for (y = 0; y < yres; y++)
    {
        float sy = 0.5f+0.5f*(0.3f*cosf(y*0.3f + pos*18) + 0.5f*cosf(y*0.171f + pos*13 + 5*cosf(y*0.07f+pos*25)));
        for (x = 0; x < xres; x++)
        {
            float sx = 0.5f+0.5f*(0.5f*cosf(x*0.24f + pos*11)+0.5f*cosf(x*0.11f + y*0.21f + pos*19));

//            Vector3 dp = Vector3(0, (sx + sy)*0.05f*(1-fmodf(pos*48, 1)), 0);
            Vector3 dp = Vector3(0, (sx + sy)*0.05f, 0);
            Vector3 col = colors[offset];

            const float tilealpha = 0.0810f;


            Vector3 u1 = vertices[(offset << 2)] + dp;
            Vector3 u2 = vertices[(offset << 2) + 1] + dp;
            Vector3 u3 = vertices[(offset << 2) + 2] + dp;
            Vector3 u4 = vertices[(offset << 2) + 3] + dp;

            Vector3 d1 = vertices[(offset << 2)];
            Vector3 d2 = vertices[(offset << 2) + 1];
            Vector3 d3 = vertices[(offset << 2) + 2];
            Vector3 d4 = vertices[(offset << 2) + 3];
            //ylosa
            glColor4f(col.x, col.y, col.z, tilealpha);
            glVertex3fv((float *)&u1);
            glVertex3fv((float *)&u2);
            glVertex3fv((float *)&u3);
            glVertex3fv((float *)&u4);
            //edess
            glVertex3fv((float *)&u3);
            glVertex3fv((float *)&u4);
            glColor4f(col.x, col.y, col.z, 0.0f);
            glVertex3fv((float *)&d4);
            glVertex3fv((float *)&d3);
            //oikealla
            glColor4f(col.x, col.y, col.z, tilealpha);
            glVertex3fv((float *)&u2);
            glVertex3fv((float *)&u3);
            glColor4f(col.x, col.y, col.z, 0.0f);
            glVertex3fv((float *)&d3);
            glVertex3fv((float *)&d2);

            offset++;
        }
    }
    glEnd();
}




Maasto::Maasto()
{	
    int x, y;
    xres = 128;
    yres = 128;

    vertices = new Vector3[xres*yres*4];
    colors = new Vector3[xres*yres];

    Texture *text = dmsGetTexture("maasto.jpg");
    unsigned int *colordata = text->getImgData();
    unsigned int colorwidth = text->getWidth();
    unsigned int colorheight = text->getHeight();

    unsigned int colorx = 36;
    unsigned int colory = 70;

    float xstep = 1.0f / xres;
    float ystep = 1.0f / yres;
    for (y = 0; y < yres; y++)
    {
        for (x = 0; x < xres; x++)
        {
            Vector3 v1 = Vector3((x - xres*0.5f)/xres, 0, (y - yres*0.5f)/yres);
            Vector3 v2 = v1 + Vector3(xstep, 0, 0);
            Vector3 v3 = v1 + Vector3(xstep, 0, ystep);
            Vector3 v4 = v1 + Vector3(0, 0, ystep);
            int color = colordata[((x+colorx)%colorwidth)+((y+colory)%colorheight)*colorwidth];
            int r = color & 0xFF;
            int g = (color >> 8) & 0xFF;
            int b = (color >> 16) & 0xFF;

            float l = v1.length();
            float maxlen = 0.5f;

            colors[x+y*xres] = Vector3(r/255.0f, g/255.0f, b/255.0f) * powf((maxlen - l)*2.5f, 1.5f)*3;
            vertices[((x+y*xres) << 2) + 0] = v1;
            vertices[((x+y*xres) << 2) + 1] = v2;
            vertices[((x+y*xres) << 2) + 2] = v3;
            vertices[((x+y*xres) << 2) + 3] = v4;
        }
    }
}


Maasto::~Maasto()
{
    delete [] vertices;
    delete [] colors;
}


bool Maasto::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

