#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "Loppukuvat.hpp"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Loppukuvat::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}

void Loppukuvat::renderScene(float pos, float alpha)
{
    glDepthMask(0);
    glDisable(GL_DEPTH_TEST);
    
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    //glBindTexture(GL_TEXTURE_2D, dmsGetTexture("image1.jpg")->getID());
    glLoadIdentity();
    dmsPerspective2D(1,1);

	glEnable(GL_TEXTURE_2D);
    float realtime = dmsGetModulePosition()*1.0f;
    float kuva1alpha = alpha*(1-Mathematics::calcPosFloat(realtime, 249000, 250000));
					//	* (1-Mathematics::calcPosFloat(realtime, 254750, 258000));

	shaders.gradientfade->bind();

		glActiveTextureARB(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, dmsGetTexture("image1.jpg")->getID());

		glActiveTextureARB(GL_TEXTURE1_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,dmsGetTexture("cau_008.jpg")->getID()); 
    
		shaders.gradientfade->setUniform1i("tex", 0);  
		shaders.gradientfade->setUniform1i("gradient", 1);  

		const float kuva1n   = Mathematics::calcPosFloat(pos, 0.0f, 0.147124303f);
		const float kuva1emp = min(1,5*kuva1n);
		const float kuva1out = 1-Mathematics::calcPosFloat(realtime, 248500, 249500);

		shaders.gradientfade->setUniform1f("value",  kuva1n*kuva1out); 
		shaders.gradientfade->setUniform1f("value2", (kuva1n+0.10f*kuva1emp)*kuva1out);

		glColor4f(1,1,1,kuva1alpha);
		glBegin(GL_QUADS);
		glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 0.0f, 1.0f);
		glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0.0f, 0.15f);
		glVertex2f(0.24f, 0);
		//glTexCoord2f(1, 1);
		glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 1.0f, 1.0f);
		glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0.15f, 0.15f);
		glVertex2f(0.76f, 0);
		//glTexCoord2f(1, 0);
		glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 1.0f, 0.0f);
		glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0.15f, 0.0f);
		glVertex2f(0.76f, 1);
		//glTexCoord2f(0, 0);
		glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 0.0f, 0.0f);
		glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0.0f, 0.0f);
		glVertex2f(0.24f, 1);
		glEnd();

    	 glActiveTextureARB(GL_TEXTURE1);
		glDisable(GL_TEXTURE_2D);

		glActiveTextureARB(GL_TEXTURE0);
		glEnable(GL_TEXTURE_2D);		

	shaders.unbind();


    float kuva2alpha = alpha*(Mathematics::calcPosFloat(realtime, 249000, 250000)) 
                            * (1-Mathematics::calcPosFloat(realtime, 254750, 258000));
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("image2.jpg")->getID());
    glColor4f(1,1,1,kuva2alpha);
    glBegin(GL_QUADS);
    glTexCoord2f(0, 1);
    glVertex2f(0, 0);
    glTexCoord2f(1, 1);
    glVertex2f(1, 0);
    glTexCoord2f(1, 0);
    glVertex2f(1, 1);
    glTexCoord2f(0, 0);
    glVertex2f(0, 1);
    glEnd();
    
    
    dmsPerspective3D();
    glLoadIdentity();
    glDepthMask(1);
}




Loppukuvat::Loppukuvat()
{	
}

Loppukuvat::~Loppukuvat()
{
}


bool Loppukuvat::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

