#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "Loppu.hpp"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Loppu::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
    glEnable(GL_TEXTURE_2D);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glDisable(GL_DEPTH_TEST);

    glLoadIdentity();
    glTranslatef(0, 0, -8);

    glEnable(GL_BLEND); 
    glColor4f(1,1,1,alpha);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("placeholder11.jpg")->getID());

    glPushMatrix();
    Primitives::drawBillboard(Vector(0, 0, 0), 3);
    glPopMatrix();
}

void Loppu::renderScene(float pos, float alpha)
{
    Vector3 cam = Vector3(0, 0, -7);
    Vector3 tgt = Vector3(0, 0, 0);
    Vector3 upw = Vector3(0, 1, 0);

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);
}




Loppu::Loppu()
{	
}

Loppu::~Loppu()
{
}


bool Loppu::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

