#ifndef _LASER_HPP_
#define _LASER_HPP_

#include <stdio.h>
#include "../library/externs.hpp"


class Emitter
{
public:
	Vector3 position;
	Vector3 direction;
	Vector3 color;
};

class Reflector
{
public:

	Vector3 position;
	Vector3 v1, v2, v3;
	Vector3 r1, r2, r3;
	Vector3 startrotation;
	Vector3 endrotation;
	Vector3 normal;
};



class Laser : public Base
{
	public:

		Laser();
		~Laser();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
		void renderScene(float pos, float alpha);
		void updateReflectors(float aika);
		bool intersectTriangle(Vector3 &origin, Vector3 &dir, Vector3 &vert0, Vector3 &vert1, Vector3 &vert2, 
							  float *t, float *u, float *v);
		int emittercount;
		int reflectorcount;

		Emitter *emitters;
		Reflector *reflectors;

};

#endif
