#ifndef _Kliimaksi_HPP_
#define _Kliimaksi_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../analyzer.hpp"
#include "../bpm.hpp"
#include "stream.hpp"


class KliimaksiHohde
{
public:
    float phase;
    float speed;

    float length;
    Vector startpos;
    Vector endpos;
    Vector color;
};

class KliimaksiParticle
{
public:
    int positioncount;
    int positionindex;
    Vector *positions;

    float colorphase;
    float colorspeed;
    float movephase1;
    float movespeed1;
    float movephase2;
    float movespeed2;
    float movephase3;
    float movespeed3;
    float moveradius;
    float positionspeed;
    float positionphase;
    float pos;
};

class KliimaksiSpline
{
public:
    float st, et;

    float aspeed;
    float aphase;

    void initParticles(int count);
    void updateParticles(float pos, float sync);

    void draw(float pos, float sync, float alpha);
    int splinepointcount;
    CatmullRom *spline;
    CatmullRom *spline2;
    Vector *deltapoints;

    float morffispeed;

    int pcount;
    KliimaksiParticle *particles;
    Vector color;
    float fade;
};


class Kliimaksi : public Base
{
	public:

		Kliimaksi();
		~Kliimaksi();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
		void renderSky(float pos, float alpha);

        int splinecount;
        KliimaksiSpline **splinet;

        float *fades;

        Analyzer *anal;

        void lookAt();
        int count;
        KliimaksiHohde *particles;
        void drawScene(float pos, float alpha);
		void renderScene(float pos, float alpha);

		TriggerSystem *triggers;
};

#endif
