#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "Equ.hpp"
#include "../mathematics.hpp"
#include "../primitives.hpp"

//#include "../configtool.hpp"
//extern ConfigTool *conf;

void Equ::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.08f;
	const float fadeinstop = 0.5f;
	const float fadeoutstart = 1.0f;
	const float fadeoutstop = 1.0f;

    alpha *= Mathematics::calcPosFloat(pos, fadeinstart, fadeinstop);
//	if (pos >= fadeoutstart && pos <= fadeoutstop)
//		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);
 
    glDisable(GL_BLEND);

	filter.init();
	renderScene(pos, alpha);
	filter.glow(5);

}

void Equ::renderScene(float pos, float alpha)
{
    int x, y;

    const float updatetime = 0.001f;
    static float prevpos = 0.0f;
    static float cumtime = 0.0f;

    float dt = pos - prevpos;

    cumtime += dt;

    while (cumtime > updatetime)
    {
        float spectrum[1024];
        dmsGetSpectrum(spectrum, 1024);

        //liikutetaan kaikkia

        for (x = 0; x < xres - 1; x++)
        {
            for (y=0;y<yres;y++)
            {
                values[x][y] = values[x+1][y];
            }
        }
        //laitetaan uudet
        for (y=0;y<yres;y++)
        {
            values[xres-1][y]  = powf(spectrum[y], 0.8f); //TODO
        }

        cumtime -= updatetime;
    }


    prevpos = pos;


    Vector cam = Vector(0-pos*0.7f, 1+pos*1.5f, -6)*(1-pos*0.2f);
    Vector tgt = Vector(0, 0, 0);
    Vector upw = Vector(0, 1, 0);

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);

    glRotatef(14+pos*60, 0, 1, 0);

    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

    glEnable(GL_LINE_SMOOTH);
    glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
    glLineWidth(1.5f);
    for (x=0;x<xres-1;x++)
    {
        glBegin(GL_LINE_STRIP);
        for (y=0;y<yres;y++)
        {
            Vector v =  points[x][y]   + Vector(0, values[x][y], 0);
            Vector v_ = points[x+1][y] + Vector(0, values[x+1][y], 0);

			// xres = 50;  //nin monta framea tallella
			// yres = 100; //nin monta pistett per frame

			//450*50
			//if(y<50)

			//x-liukuu
//			if(y>35 && y<35+51)
//			{
			 // MAAGISIA LUKUJA KDET IRTI x) 
//			 int from= (x+40+int(pos*pos*pos*380))+(50-(y-35))*450;
//			 if(from<BITMASK_SIZE)
//			  if(bitmask[from]==1)
//			  {
//				 v.y +=0.1375f;
//				 v_.y+=0.1375f;
//			  }
//			}


            float dy = v.y - v_.y;
            float dz = v.z - v_.z;

            const float a = alpha*(0.6f+(dy*15)-v.z*0.34f*(1-pos));
            glColor4f(a, a, a, a);

        
			Vector v2 = v + Vector(0.015f, 0.01f, 0);
            glVertex3fv((float *)&v);
            glVertex3fv((float *)&v2);

        }
        glEnd();
    }
    glEnd();
    glDisable(GL_LINE_SMOOTH);
}




Equ::Equ()
{	
    int x, y;
    xres = 50; //nin monta framea tallella
    yres = 100; //nin monta pistett per frame

    points = new Vector*[xres];
    values = new float*[xres];

    for (x = 0; x < xres; x++)
    {
        points[x] = new Vector[yres];
        values[x] = new float[yres];

        for (y = 0; y < yres; y++)
        {
            const float xsize = 4.0f;
            const float ysize = 4.0f;
            float xpos = (x - xres*0.5f)/xres * xsize;
            float ypos = (y - yres*0.5f)/yres * ysize;
            points[x][y] = Vector(xpos, 0, ypos);

        }
    }
}

Equ::~Equ()
{
    int x;
    for (x=0;x<xres;x++)
    {
        delete [] points[x];
        delete [] values[x];
    }
    delete [] points;
    delete [] values;

}


bool Equ::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

