#ifndef _Elokuva_HPP_
#define _Elokuva_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "../analyzer.hpp"

class PikkuSpline
{
public:
	void draw(float pos, float analval, float alpha);

	float st;
	float et;
	CatmullRom *path;
	Vector direction;
};

class Viiva
{
public:

	void draw(float pos, float sync, float analval, float alpha);
	
	float a1;
	float a2;

	Vector p1, p2;

	float speed;
	float phase;
	float rad;


};

class Elokuva : public Base
{
	public:

		Elokuva();
		~Elokuva();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:

		int vcount;
		Viiva *viivat;

		int count;
		PikkuSpline **splinet;

		Analyzer *anal;
		CatmullRom *path;
		CatmullRom *kamera;
		void renderScene(float pos, float alpha);

		TriggerSystem *trigger;

		int triggersHit;
};

#endif
