#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "CamTesti1.hpp"
#include "../library/mathematics.hpp"
#include "../library/primitives.hpp"

void CamTesti1::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

    //filter.init(true);
	renderScene(pos, alpha);
    //filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}

void CamTesti1::renderScene(float pos, float alpha)
{
    int i;
    cam->useCamera(0);

    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glEnable(GL_LINE_SMOOTH);

    int slices = 50;
    const float size = 15.0f;

    glColor4f(1,0,0,alpha);
    glBegin(GL_LINES);
    for (i = 0; i < slices; i++)
    {
        const float t = i / (float)slices;
        float x = -size*(1-t) + size*t;

        Vector3 v1 = Vector3(x, 0, -size);
        Vector3 v2 = Vector3(x, 0, size);
        glVertex3fv((float *)&v1);
        glVertex3fv((float *)&v2);

    }
    

    glEnd();

    glColor4f(0.3f,0.8f,1,alpha);
    Primitives::wireCube(0.50f);


    glDisable(GL_BLEND);

    glDisable(GL_LINE_SMOOTH);


}




CamTesti1::CamTesti1()
{	
}

CamTesti1::~CamTesti1()
{
}


bool CamTesti1::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

