#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "BezierTesti.hpp"
#include "../library/mathematics.hpp"
#include "../library/primitives.hpp"

void BezierTesti::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

    //filter.init(true);
	renderScene(pos, alpha);
    //filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}

void BezierTesti::renderScene(float pos, float alpha)
{
    int i;
/*
    Vector3 cam = Vector3(0, 0, -7);
    Vector3 tgt = Vector3(0, 0, 0);
    Vector3 upw = Vector3(0, 1, 0);

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);
*/
    cam->useCamera(0);
//    glRotatef(pos*130, 0.7f, 1, 0.3f);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flower64x64.png")->getID());
    glColor4f(1,1,1,alpha);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glDisable(GL_DEPTH_TEST);

    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

    Vector3 *realtangents = new Vector3[pcount];
    float move_t = sinf((0.5f+0.5f*cosf(pos*38))*3.141592f);
    for (i = 0; i < pcount; i++)
    {
        realtangents[i] = tangents[i]*(1-move_t) + tangents2[i]*move_t;
        spline->setPoint(i, points[i], realtangents[i]);
    }



    //piirretn pisteet
    Primitives::drawBillboard(points[0], 0.1f);
    Primitives::drawBillboard(points[pcount-1], 0.1f);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("particle3.jpg")->getID());
    for (i = 1; i < pcount - 1; i++)
    {
        Primitives::drawBillboard(points[i], 0.1f);
    }

    glDisable(GL_TEXTURE_2D);
    glColor4f(0,0,1,0.7f*alpha);
    glEnable(GL_LINE_SMOOTH);
    glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);

    float t = 1.0f;//fmodf(pos*4, 1);
    glBegin(GL_LINE_STRIP);
    
    for (float u = 0.0f; u < t; u += 0.0001f)
    {
        Vector3 splinepoint = spline->getValue(u);
        glVertex3fv((float *)&splinepoint);
    }
    glEnd();

    glColor4f(0,1,0,0.6f*alpha);
    glBegin(GL_LINES);
    for (i = 0; i < pcount; i++)
    {
        Vector3 v1 = spline->points[i];
        Vector3 v2 = spline->tangents[i];
        glVertex3fv((float*)&v1);
        glVertex3fv((float*)&v2);
    }
    glEnd();

    glColor4f(1,1,1,0.5f*alpha);
    Primitives::wireCube(3);
    glDisable(GL_LINE_SMOOTH);

    delete [] realtangents;

}




BezierTesti::BezierTesti()
{	
    int i;
    pcount = 16;
    points = new Vector3[pcount];
    tangents = new Vector3[pcount];
    tangents2 = new Vector3[pcount];

    Vector3 p = Vector3(-2, 0, 0);
    spline = new Bezier(pcount);

    Vector3 avg = Vector3(0, 0, 0);
    for (i = 0; i < pcount; i++)
    {
//        p += Vector3(0, Mathematics::randFloat()-0.5f,Mathematics::randFloat()-0.5f);
//        p += Vector3(1, 0, 0);

        p += Mathematics::randVectSphere()*1.4f;
        points[i] = p;
        avg += p;
    }
    avg *= 1.0f / pcount;

    for (i = 0; i < pcount; i++)
    {
        points[i] -= avg;
        tangents[i] = Mathematics::randVectSphere()*Mathematics::randFloat()*(0.2f+0.4f);
        tangents2[i] = Mathematics::randVectSphere()*Mathematics::randFloat()*(0.4f+0.8f);
    }
}

BezierTesti::~BezierTesti()
{
	delete [] points;
	delete [] tangents;
	delete [] tangents2;
//	delete spline;

//    delete [] points;
    //delete spline;
}


bool BezierTesti::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

