#ifndef _BezierKukka_HPP_
#define _BezierKukka_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "stream.hpp" //streamparticle

class ParticleBezier
{
public:
    ParticleBezier();
    ParticleBezier(int particlecount, int maxpoints);
    ~ParticleBezier();

    void addPoint(Vector &point, Vector &tangent);
    void setPoint(int index, Vector &point, Vector &tangent);

    void draw(float pos, float alpha, Vector &color);
    Bezier *curve;
    Bezier *usedcurve;
private:
    int bezierpoints;
    int pcount;

    StreamParticle *particles;
};

class Petal
{
public:
    Petal(float kulma, float lehdenkulma, float yla, Matrix &rot, Vector &petalcolor);
    void draw(float pos, float alpha);

    Vector start;
    Vector end;
    Vector petalcolor;
    Vector edgecolor;
    ParticleBezier *left;
    ParticleBezier *right;

};
class Flower
{
    public:
        Flower(int petalcount);
        ~Flower();
        void draw(float alpha, float t);

        Vector pos;
        ParticleBezier *varsi;
        int petalcount;
        Petal **petals;
        int textureID;

        float st;
        float et;
};

class Kukkaspiraali
{
public:
    void draw(float pos, float alpha);
    float st;
    float et;

    int count;
    Vector color;
    Vector *vertices;

    Vector movedelta;


};



class BezierKukka : public Base
{
	public:

		BezierKukka();
		~BezierKukka();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
        int flowercount;
        Flower **flowers;

        int spiraalicount;

        Kukkaspiraali **spiraalit;
		void renderScene(float pos, float alpha);
};

#endif
