#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "Alkutekstit.hpp"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Alkutekstit::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}

void Alkutekstit::renderScene(float pos, float alpha)
{

    //dmsMsg("alkutekstit::renderScene()\n");

	// -- 3d

	// Tyhjennetn depth buffer 
	glClear(GL_DEPTH_BUFFER_BIT);

    glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
	glBlendFunc(GL_ONE, GL_ONE);
    glEnable(GL_TEXTURE_2D);

	glLoadIdentity();
    
	glTranslatef(0, 0, -22+pos*3.0f);
	
	glRotatef(140+pos*24,1,-1,1);

    int facecount	= kuu->getFaceCount();
    Vector *vertices= kuu->getVertices();
    Vector *normals = kuu->getNormals();
    Face *faces		= kuu->getFaces();
    TexCoord *uv	= kuu->getUV();
    
	Matrix valorotate;
    valorotate.makeRotation(5+pos*9, 0, 0);
    Vector light = Vector(1, 1, 1)*valorotate;
	light = light.normalize();
	
	glColor3f(1,1,1);

	// Cull to remove ugly artifacts
	glCullFace(GL_BACK);
	glEnable(GL_CULL_FACE);

	shaders.lightfade->bind();

		glActiveTextureARB(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, dmsGetTexture("texture-moon.jpg")->getID());

		glActiveTextureARB(GL_TEXTURE1_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,dmsGetTexture("cau_002.jpg")->getID()); 
    
		shaders.lightfade->setUniform1i("tex", 0);  
		shaders.lightfade->setUniform1i("gradient", 1);  

		const float kuva1n  =   Mathematics::calcPosFloat(pos, 0.0f, 0.3124303f);
		const float kuva1ut = 1-Mathematics::calcPosFloat(pos, 0.3130f, 0.52728f);
		const float kuva1emp = min(1,5*kuva1n);

		shaders.lightfade->setUniform1f("value",  kuva1n*kuva1ut); 
		shaders.lightfade->setUniform1f("value2", (kuva1n+0.10f*kuva1emp)*kuva1ut);
		shaders.lightfade->setUniform3f("lightDir", light.x, light.y, light.z);

					glBegin(GL_TRIANGLES);
					int i;
					for (i=0;i<facecount;i++)
					{
						Face &f = faces[i];
						Vector &v1 = vertices[faces[i].v1];
						Vector &v2 = vertices[faces[i].v2];
						Vector &v3 = vertices[faces[i].v3];

						TexCoord &uv1 = uv[faces[i].v1];
						TexCoord &uv2 = uv[faces[i].v2];
						TexCoord &uv3 = uv[faces[i].v3];

						Vector &n1 = normals[faces[i].v1];
						Vector &n2 = normals[faces[i].v2];
						Vector &n3 = normals[faces[i].v3];

						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, uv1.u, uv1.v);
						glMultiTexCoord2fARB(GL_TEXTURE1_ARB, uv1.u, uv1.v);
						glNormal3fv((float *)&n1);
						glVertex3fv((float *)&v1);

						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, uv2.u, uv2.v);
						glMultiTexCoord2fARB(GL_TEXTURE1_ARB, uv2.u, uv2.v);
						glNormal3fv((float *)&n2);
						glVertex3fv((float *)&v2);
					
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, uv3.u, uv3.v);
						glMultiTexCoord2fARB(GL_TEXTURE1_ARB, uv3.u, uv3.v);
						glNormal3fv((float *)&n3);
						glVertex3fv((float *)&v3);
					}
					glEnd();
						
	 		glActiveTextureARB(GL_TEXTURE1);
			glDisable(GL_TEXTURE_2D);

		glActiveTextureARB(GL_TEXTURE0);
		glDisable(GL_TEXTURE_2D);		

	shaders.unbind();
glDisable(GL_CULL_FACE);

	// -- 2d

    glDisable(GL_DEPTH_TEST);
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glLoadIdentity();
    dmsPerspective2D(1,1);


	

/*
	// !!!!
	// lh preacher raiskaa nit kommentoitui koodei

	shaders.gradientfade->bind();
*/
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("grouplogo.png")->getID());
/*
	glActiveTextureARB(GL_TEXTURE1_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D,dmsGetTexture("cau_001.jpg")->getID()); 
    
	shaders.gradientfade->setUniform1i("tex", 0);  
	shaders.gradientfade->setUniform1i("gradient", 1);  
*/
	//float kuva1alpha = (Mathematics::calcPosFloat(pos, 0.0f, 0.203f))*);;
	const float kuva1in = Mathematics::calcPosCos(pos, 0.0f, 0.303f);
	const float kuva1out = 1-Mathematics::calcPosCos(pos, 0.30f, 0.5f);
	const float kuva1temp = min(1,3*kuva1in);
/*
	shaders.gradientfade->setUniform1f("value",  kuva1in*kuva1out); 
	shaders.gradientfade->setUniform1f("value2", (kuva1in+0.10f*kuva1temp)*kuva1out);
*/	 

	glColor4f(1,1,1,kuva1in*kuva1out);
    glBegin(GL_QUADS);
    glTexCoord2f(0, 1);
    glVertex2f(0, 0);
    glTexCoord2f(1, 1);
    glVertex2f(1, 0);
    glTexCoord2f(1, 0);
    glVertex2f(1, 1);
    glTexCoord2f(0, 0);
    glVertex2f(0, 1);
    glEnd();

	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glDisable(GL_TEXTURE_2D);
/*
	shaders.unbind();
*/

	// Kuva 2

	shaders.gradientfade->bind();

	glActiveTextureARB(GL_TEXTURE0_ARB);
	glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("demoname.png")->getID());

	glActiveTextureARB(GL_TEXTURE1_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D,dmsGetTexture("cau_005.jpg")->getID()); 
    
	shaders.gradientfade->setUniform1i("tex", 0);  
	shaders.gradientfade->setUniform1i("gradient", 1);  

	float kuva2in = Mathematics::calcPosFloat(pos, 0.477f, 0.58f);
	float kuva2out = 1-Mathematics::calcPosFloat(pos, 0.65f, 0.85f);
	shaders.gradientfade->setUniform1f("value",  kuva2in*kuva2out); 
	shaders.gradientfade->setUniform1f("value2", (kuva2in+0.1f*kuva2in)*kuva2out);
    
    glBegin(GL_QUADS);
    glTexCoord2f(0, 1);
    glVertex2f(0, 0);
    glTexCoord2f(1, 1);
    glVertex2f(1, 0);
    glTexCoord2f(1, 0);
    glVertex2f(1, 1);
    glTexCoord2f(0, 0);
    glVertex2f(0, 1);
    glEnd();
    

	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glDisable(GL_TEXTURE_2D);

	shaders.unbind();

    dmsPerspective3D();
    glLoadIdentity();
    glDepthMask(1);

}




Alkutekstit::Alkutekstit()
{	
}

Alkutekstit::~Alkutekstit()
{
	delete kuu;
}


bool Alkutekstit::init(unsigned long s, unsigned long e)
{

    kuu = new Mesh();
	
	const int res = 58;
    //kuu->buildAsteroid(6, res, res, size, 1.0f);
	kuu->buildSphere(6, res, res, 1.0f);

	startTime = s;
	endTime = e;
	return true;
}

