#ifndef _CAMERA_HPP_
#define _CAMERA_HPP_

#include "externs.hpp"
#include "catmullrom.hpp"

extern class CameraHolder *cam;

class Camera
{
public:
    Vector position;
    Vector direction;
    Vector upwards;

    int st;
    int et;

    class CatmullRom *path;
    class CatmullRom *target;

};

class CameraHolder
{
public:
    CameraHolder();
    CameraHolder(int count);
    ~CameraHolder();

    void update();

    void initCamera(int index, int maxpoints, int starttime, int endtime);
    void addCameraPoint(int index, Vector &point);
    void addCameraTargetPoint(int index, Vector &point);
    void setCameraPoint(int index, Vector &point);
    void setCameraTargetPoint(int index, Vector &point);
    void useCamera(int index);

    Camera& getCamera(int index);

    int time;
    int camcount;
    Camera *cameras;



};

#endif