#ifndef _GLOBALS_HPP_
#define _GLOBALS_HPP_

//--------------------------------------------------------------------------------------------
//  Headers
//--------------------------------------------------------------------------------------------

#include <windows.h>
#include "parser.hpp"
#include "opengl.hpp"
#include "log.hpp"
#include "timer.hpp"
#include "sound.hpp"
#include "texturemanager.hpp"
#include "effectmanager.hpp"
#include "fontmanager.hpp"
#include "objectmanager.hpp"
#include "fx.hpp"

//--------------------------------------------------------------------------------------------
//  Function prototypes
//--------------------------------------------------------------------------------------------

extern "C" __declspec(dllexport) void dmsMsg(const char *text, ...);
extern "C" __declspec(dllexport) void dmsClearConsole();
extern "C" __declspec(dllexport) void dmsConsoleMsg( int x, int y, const char *text, ...);
extern "C" __declspec(dllexport) void checkState();
extern "C" __declspec(dllexport) void myEnable(int c);
extern "C" __declspec(dllexport) void myDisable(int c);
extern "C" __declspec(dllexport) void myBlendFunc(int src, int dst);
//extern "C" __declspec(dllexport) void dmsPerspective2D(int w, int h);
//extern "C" __declspec(dllexport) void dmsPerspective3D();
extern "C" __declspec(dllexport) int dmsGetWindowWidth();
extern "C" __declspec(dllexport) int dmsGetWindowHeight();
extern "C" __declspec(dllexport) int dmsGetModulePosition();
//extern "C" __declspec(dllexport) HWND dmsGetHWND();
//extern "C" __declspec(dllexport) void dmsLoadBar(float status);

#endif