#ifndef _FX_HPP_
#define _FX_HPP_

//--------------------------------------------------------------------------------------------
//  Headers
//--------------------------------------------------------------------------------------------

#include "base.hpp"
#include "vector.hpp"

//--------------------------------------------------------------------------------------------
//  This code belongs to our library namespace: TRACTION_DEMOTRACTOR
//--------------------------------------------------------------------------------------------

namespace TRACTION_DEMOTRACTOR
{

//--------------------------------------------------------------------------------------------
//  Singleton FX class
//--------------------------------------------------------------------------------------------

	class FX
	{	
		public:

			~FX();

			static FX *create();
			
			void drawQuad2D();
			void drawQuad2D(Vector p1, Vector p2, Vector p3, Vector p4);
			void drawTexturedQuad2D();
			void drawTexturedQuad2D(Vector p1, Vector p2, Vector p3, Vector p4);
			void blending(bool blendOn, unsigned int src, unsigned int dst);
					
			void release();

		private:

			static bool createdFlag;			// true jos yksi instanssi olemassa
			static FX *instance;
			
			// kun nm on privatena niin voidaan est uusien ilmentymien luonti
			FX();
			FX(const FX&) {}
			FX& operator = (const FX&) {}

	};

}

#endif