#ifndef _Math_HPP_
#define _Math_HPP_

#include "externs.hpp"

class Math
{
public:
	Math(unsigned long s = 5489UL) {}; 
	~Math() {};

	//palauttaa Vectorn, jossa on halutut pallokoordinaatit karteesisessa koordinaatistossa
	//phi = [0, pii], theta = [0, 2*pii], radius = [0, inf]
	static Vector sphereToCartesian(float radius, float phi, float theta);
	//palauttaa Vectorn, jossa on halutut karteesiset koordinaatit pallokoordinaatistossa
	//v = [radius, phi, theta]. Ei huomioi, miss segmentiss ollaan joten muista tarkistaa
	//kulmat!
	static Vector cartesianToSphere(float x, float y, float z);

	//numeerinen integrointi Simpsonin menetelmll
	static float integrateSimpson(float startpoint, float endpoint, int steps, float(*function)(float));
	static void antiRotate(Vector3 *x, Vector3 *y, Vector3 *z);
	static float calcSaturate(float value, float limit1, float limit2, float multiply);
	static float calcPosFloat(float value, float limit1, float limit2);
	static float calcPosCos(float value, float limit1, float limit2);

	static void getQuadraticBezierPoint(Vector3 p1, Vector3 p2, Vector3 p3, float t, Vector3 *point);

	// Smooth step algo
	static float calcSmoothStep(float value, float limit1, float limit2);
	// palauttaa [0 - 1]
	static float randFloat();
    // palauttaa [min, max]
    static float randBetween(float min, float max);
	// palauttaa rand()%i
	static int randInt(int i);
	// palauttaa [0 - i]
	static float randFloat(float i);

	static float minimum(float val, float minimi);
	static float maximum(float val, float max);
	static float clampVal(float val, float min, float max);
	

	// Vector( [-0.5f,0.5f] , ..)
	static Vector randVector();

	// Vector( [-0.5f, 0.5f]*kerroin
	static Vector randVector(float dx, float dy, float dz);

	// Vector( [0,1] , ..);
	static Vector randVector2();
	
    static Vector randVectSphere();
    static Vector randVectPlane();

	static float getClosest(float value, float first, float second);

	// Mersenne twister

	// initializes state[n] with a seed
    void init_genrand(unsigned long s);

    // generates a random number on [0,0xffffffff]-interval 
    unsigned long genrand_int32();

    // generates a random number on [0,0x7fffffff]-interval 
    long genrand_int31();

    // generates a random number on [0,1]-real-interval 
    float genrand_real1();

    // generates a random number on [0,1)-real-interval 
    float genrand_real2();

    // generates a random number on (0,1)-real-interval
    float genrand_real3();

    // generates a random number on [0,1) with 53-bit resolution
    float genrand_res53();

private:
	// Mersenne twister 
	enum MT_ENUM
    {
        N = 624
    };

    void next_state();
    unsigned long state[N]; 
    int left;
    unsigned long *next;

};

#endif