//-------------------------------------------------------
//	Defines
//-------------------------------------------------------
// Changes removes  adds fadeout
//#define NOT_FINAL

#define MAKE_PAK

//#define DO_NOT_UPLOAD_TEXTURES_AT_START
//#define DO_NOT_PLAY_AUDIO
//#define RALE_SETTINGS

#define WIN32_LEAN_AND_MEAN
#define VC_LEANMEAN           

//-------------------------------------------------------
//	Headers
//-------------------------------------------------------

#pragma warning(disable: 4244)

#include <windows.h>
#include <mmsystem.h>
#include <shellapi.h>
#include <stdlib.h>
#include <stdio.h>
#include "resource.h"

// Effects
#include "effects/runko.h"
//#include "effects/3dtest.h"
//#include "effects/3dtest2.h"
//#include "effects/3dtest3.h"
#include "effects/fisut.h"
#include "effects/virtaus.h"
#include "effects/meduusa.h"
#include "effects/pohja.h"
#include "effects/uppo.h"
#include "effects/tyonto.h"
#include "effects/nilviaiset.h"
#include "effects/caustic.h"
#include "effects/stream.h" 
#include "effects/oliot.h"
#include "effects/water.h"
#include "effects/ravintoketju.h"
#include "effects/suihkeet.h"
#include "effects/alkuotukset.h"
#include "effects/metsae.h"
#include "effects/vihoviimeinen.h"
#include "effects/maailma.h"
#include "effects/metakappyra.h"
#include "effects/sivuttain.h"
#include "effects/credits.h"
#include "effects/Greets.h"

#include "effects/ropes.h"
//#include "effects/huttu.h"

#include "externs.hpp"
#include "config.hpp"
#include "extension_functions.hpp"
#include "primitives.hpp"
#include "ConfigTool.h"

#include "camera.hpp"


using namespace TRACTION_DEMOTRACTOR;

CameraHolder *cameras;
Analyzer *analyzer;
Ext glExt;
PostProc filter;
ShaderManager *shaders = NULL;

#ifdef NOT_FINAL
ConfigTool *tool;
#endif

//BPM *beat;
//BPM *beat_here;
Vector clearcol;
const float FadeOutMaxTime = 1.15f;
bool fadeDemoOut(float &f);

// x < 0 => reset to default
void setClearColor(Vector3 color)
{
	if(color.x<0) color = Vector3(0.01f, 0.01f,0.03f);
	clearcol = color;
	GroundPlane::setFadeColor(clearcol);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{	

    int i = 0;
	int rewind_dir;
	rewind_dir = 0;	

	// Stores messages that windows sends to the application
	MSG msg = {0};			
	HDC hdc = NULL;
	bool done = false;

	setClearColor(Vector3(0,0,0));
	
	//clearcol = Vector(0.41f,0.41f,0.4f);
    
	try
	{
 	    // Tee PAK-tiedosto ksin
#ifdef NOT_FINAL
		dmsSetLogging(true);
#endif

#ifdef MAKE_PAK
		dmsMakePAK("resources", "data.pak");
#endif
	

		Config *cfg = new Config();


#ifndef RALE_SETTINGS
		cfg->run(); 
		if(cfg->getRunFlag()) 
#endif
        {

#ifndef RALE_SETTINGS

		Config::sound = true;
        dmsInitEx(cfg->getScreenX(), cfg->getScreenY(), cfg->getBpp(), cfg->getFullscreen(), 
				  cfg->getSound(), cfg->getVsync(), cfg->getOnTop(), 0, cfg->getAspectRatio(), "data.pak", cfg->getFrequency());


      
		//dmsReadPak("data.pak");
		//dmsReadDir("resources");
		//dmsReadDir("resources");
		//dmsInitObjects();
		
		dmsSetWindowTitle("Traction.Brainstorm :: Challenger Deep");

        //efektit:
        // - parveilusysteemi
        // - koralli
        // - paratiisikalat (?)
        // - meduusa(t)
        // - planktonia
        // - joku hieno jytky
        // - particleilla rendattu koralli, joka emittoi otuksia
        // - koralli, joka hajoaa kokonaan otuksiksi
        // - anisotrooppinen shaderi (normalmap), jossa vri vaihtuu kesken shaderoinnin (sellainen "Kimaltava" pinta kuin esim. neontetroilla)
        //
        // toimisiko hehkuvan punainen ja oranssi sinisen vastapainona harvoissa ja valituissa skeneiss?

	
        //TODO:
        // - Uppo:
        //     - kuutiot pois
        //     - taajuuden st
        //     - liike otuksille
        //     - erilaisia otuksia (pieni boidisysteemej?)
        //
        // - Pohja:
        //     - pohjatekstuuri ja siihen valaistus
        //     - viuhuvat lentvt otukset
        //
        // - Meduusa:
        //     - tuunatut liikkeet
        //     - shaderoitu varjostus
        //     - lis dynamiikkaa liikkeeseen
        //
        // - Virtaus:
        //     - splinejen liike + kunnon fysiikat
        //     - particleja splinejen tilalle ja viivat pois 
        //     - spline+spline collisiot ett ne saa liikkumaan kunnolla
        //
        //  Geneerinen boidisysteemi

#else
	
			//dmsInitDummyEx(cfg->getScreenX(), cfg->getScreenY(),32 ,false, !true, !true, false, 1, 120);
			dmsInitDummyEx(1024, 768, cfg->getBpp() ,false, true, !true, false, 1, 120);
			//dmsReadPak("data.pak");
			dmsSetWindowTitle("-");
			dmsReadDir("vajaat_resourcet");
			//dmsReadPak("data.pak");
			dmsInitObjects();

#endif

#ifdef NOT_FINAL
			tool = new ConfigTool(cfg->getScreenX(), cfg->getScreenY());
			tool->init();
			tool->load();
#endif


			// Asetetaan ikoni ikkunalle
			SendMessage(dmsGetHWND(),WM_SETICON,ICON_BIG,(LPARAM)LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICON1)));

			dmsSetMipMaps("smoke1.jpg", true);
			dmsSetMipMaps("smoke2.jpg", true);
			dmsSetMipMaps("smoke3.jpg", true);
			dmsSetMipMaps("smoke4.jpg", true);
			dmsSetTextureParameter("smoke1.jpg", GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			dmsSetTextureParameter("smoke1.jpg", GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
			dmsSetTextureParameter("smoke2.jpg", GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			dmsSetTextureParameter("smoke2.jpg", GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
			dmsSetTextureParameter("smoke3.jpg", GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			dmsSetTextureParameter("smoke3.jpg", GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
			dmsSetTextureParameter("smoke4.jpg", GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			dmsSetTextureParameter("smoke4.jpg", GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);

#ifdef DO_NOT_UPLOAD_TEXTURES_AT_START
			dmsUploadTextures();
#endif			
            Primitives::init();
						
			glExt.init();

            cull = new FrustumCuller();
			
			shaders = ShaderManager::create();

            const int CAMERA_COUNT = 3;
            const int CAMERA_TIMES[][2] = 
            {
                {0, 300000},
                {0, 300000},
                {0, 300000},
            };
            const int CAMERA_SEEDS[CAMERA_COUNT] = 
            {
                401,
                551591,
                50,
            };
            const int CAMERA_POINTCOUNTS[CAMERA_COUNT] = 
            {
                10,
                20,
                40,
            };
            const float CAMERA_RADII[CAMERA_COUNT][2] =     
            {
                {8.0f, 12.0f}, //min, max
                {5.0f, 10.0f},
                {10.0f, 20.0f},

            };

            cameras = new CameraHolder(CAMERA_COUNT);

            for (int i = 0; i < CAMERA_COUNT; i++)
            {
                srand(CAMERA_SEEDS[i]);
                int count = CAMERA_POINTCOUNTS[i];

                cameras->initCamera(i, CAMERA_TIMES[i][0], CAMERA_TIMES[i][1]);
                for (int j = 0; j < count; j++)
                {
                    float r = Math::randBetween(CAMERA_RADII[i][0], CAMERA_RADII[i][1]);
                    Vector3 p = Math::randVectSphere() * r;

                    if (i == 0 || i == 1 || i == 2)
                    {
                        p.y = 0.2f * fabsf(p.y) + 2.5f;
                    }   

                    Vector3 target = Math::randVectSphere() * r * 0.6f;

                    if (i == 2)
                    {
                        p.y += 0;
                        target.y = p.y;// * 1.2f + 0.5f;
                    }
                    if (i == 0)
                    {
                        target.y += 1.5f;
                    }
                    cameras->addCameraPoint(i, p);
                    cameras->addCameraTargetPoint(i, target);

                }
                cameras->finalizeCamera(i);
                cameras->arcLengthParametrizeCamera(i);
                cameras->arcLengthParametrizeCameraTarget(i);
            }

			

#define COMPLETE_DEMO
#ifndef COMPLETE_DEMO

			//dmsAddEffect(296000, 308000, 0, "Greets",		new Greets());
			//dmsAddEffect(0,		10500, 0, "fairyt",			new Stream());
			//dmsAddEffect(0,		30500, 0, "fairyt",			new Sivuttain());
			//dmsAddEffect(255000, 305000, 0, "fairyt",		new Sivuttain());
			//dmsAddEffect(0, 30500, 10, "pohja",		new Pohja());
			//dmsAddEffect(450,		30500, 0, "fairyt",			new Ropes());
			//dmsAddEffect(8000,	68500, 10, "test",			new Uppo());
			//dmsAddEffect(40000,	64500, 15, "test",			new MetaKappyra());
			//dmsAddEffect(36000,	56000, 10, "test",		new Water());
			//dmsAddEffect(0000,	30000, 10, "test",		new Oliot());
		//	dmsAddEffect(000, 25500, 10, "test",	    new Suihkeet());
			//dmsAddEffect(0000,	36000, 10, "test",		new Tyonto());
			//dmsAddEffect(00000, 17000, 0, "test",	new Water());
			//dmsAddEffect(0, 15000, 0, "Credits",		new Credits());
			//dmsAddEffect(1500, 25000, 10, "ropes",		new Ropes());
			//dmsAddEffect(221500, 254500, 10, "ropes",		new Ropes());
	//		dmsAddEffect(0, 16000, 10, "credits",	new Credits());
			//dmsAddEffect(20000,	36000, 10, "test",		new Meduusa());
            //dmsAddEffect(36000, 50000, 666, "r", new Ravintoketju());	
			dmsAddEffect(00000, 20000, 0, "test",	new Fisut());
//			dmsAddEffect(20000,	36000, 10, "test",		new Meduusa());
			//dmsAddEffect(20000,  40000, 0, "test",	new Synkkakappale());
			//dmsAddEffect(296000, 308000, 0, "Greets",		new Greets());
			//dmsAddEffect(305000, 362000, 10, "viimeinen",	new Vihoviimeinen());
			//dmsAddEffect(346000, 361000, 10, "credits",		new Credits());
#else			
			dmsAddEffect(0,		10500, 0, "fairyt",			new Stream());
			dmsAddEffect(8000,	66500, 10, "uppo",			new Uppo());
			dmsAddEffect(39000,	65500, 5, "metakappyra",	new MetaKappyra());
			dmsAddEffect(66500,	91000, 10, "metsae",		new Metsae());
			dmsAddEffect(91000,	150000, 10, "meduusa",		new Meduusa());
			dmsAddEffect(72000, 150000, 10, "alkuotukset",	new Alkuotukset()); //pikkuotukset pohjan ja meduusan vlill
			dmsAddEffect(150000, 167000, 0, "fisut",		new Fisut());
			dmsAddEffect(167000, 182800,10, "tyonto",		new Tyonto());
			dmsAddEffect(182950, 204000, 10, "oliot",		new Oliot());
			dmsAddEffect(204000, 221500, 10, "suihke",	    new Suihkeet());
			dmsAddEffect(221500, 254500, 10, "ropes",		new Ropes());
			dmsAddEffect(254500, 305000, 0, "fairyt",		new Sivuttain());
			dmsAddEffect(296000, 308000, 0, "Greets",		new Greets());
			dmsAddEffect(305000, 362000, 10, "viimeinen",	new Vihoviimeinen());
			dmsAddEffect(346000, 361000, 5, "credits",		new Credits());
			

#endif
            
			analyzer = new Analyzer(50);
			//beat = new BPM(90, 0);
					
			dmsInitEffects();
	

			// T bugaa
			//dmsSetGamma(cfg->getGamma());
			dmsInitTimer();
			dmsPlaySong(true);
		}

#ifndef RALE_SETTINGS
		else
		{
			done = true;
		}
#endif		

		float fadeOutTime=0;
		// Demo loop
		while(!done)
		{

			// Check for Windows messages in queue
			if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
			{

				if(msg.message == WM_QUIT)
				{
					if(fadeOutTime==0)
					{
						fadeOutTime = FadeOutMaxTime;
					}
				} 
				else 
				{
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}

			}
			else
			{	

				dmsUpdateTimer();
                cameras->update();
				
				const float jump = 1000.0f;
				if(dmsGetKey(VK_ESCAPE))
				{
					if(fadeOutTime==0) fadeOutTime = FadeOutMaxTime;
				}

	            glClearColor(clearcol.x, clearcol.y, clearcol.z, 1);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

				//filter.drawNoiseOverlay(analyzer->get()*tool->getValue("slider1")*0.1f);

				dmsRun();
				
#ifdef NOT_FINAL
			
				if(dmsGetKey(VK_SPACE))
				{
					//dmsSetVolume(100);
					dmsSetKey(VK_SPACE, false);
					tool->visible = !tool->visible;
					dmsPauseSong(tool->visible);
					ShowCursor(tool->visible);
				}
							
				if(!tool->update(msg))
				{
					if(dmsGetKey(VK_UP))	
					{
						dmsSetVolume(100);
					}
					if(dmsGetKey(VK_DOWN))	
					{
						dmsSetVolume(0);
					}
					if(dmsGetKey(VK_LEFT))	
					{
						dmsSetVolume(0);
						rewind_dir = -1;
					}
					else if(dmsGetKey(VK_RIGHT))	
					{
						dmsSetVolume(0);
						rewind_dir = 1;
					} 
					else 
					{
						if(rewind_dir!=0)
						{
							dmsSetVolume(100);
							rewind_dir = 0;
						}
					}

					if(rewind_dir!=0) 
					{
						dmsAdjustTime(rewind_dir*1000.0f);
					}
				}

		#ifdef DO_NOT_PLAY_AUDIO
				if(!dmsGetKey(VK_UP))
				dmsSetVolume(0);
		#endif
#else
				if(dmsGetKey(VK_F1))
				{
					if(dmsGetKey(VK_LEFT))	
					{
						dmsSetVolume(0);
						rewind_dir = -1;
					}
					else if(dmsGetKey(VK_RIGHT))	
					{
						dmsSetVolume(0);
						rewind_dir = 1;
					} 
					else 
					{
						if(rewind_dir!=0)
						{
							dmsSetVolume(100);
							rewind_dir = 0;
						}
					}

					if(rewind_dir!=0) 
					{
						dmsAdjustTime(rewind_dir*1000.0f);
					}

				}
#endif




		#ifdef NOT_FINAL
					char buf[256] = {0};
					sprintf(buf, "Time: %f s | FPS: %0.2f", dmsGetModulePosition() / 1000.0f, dmsGetFPS() );
					dmsSetWindowTitle(buf);
					if(fadeOutTime>0) 
					{
						done = true;
					}
		#else
					// smooth fade out
					if(fadeOutTime>0) 
					{
						done = fadeDemoOut(fadeOutTime);
					}
		#endif	

				if (dmsGetModulePosition() > 363000)  // END
				{
					done = true;
				}

				hdc = dmsGetHDC();
				SwapBuffers(hdc);
			}
		}
	}
	catch(const char *msg)
	{
		dmsMsg("Exception: %s\n", msg);
	}

	glExt.deinit();
	shaders->release();
	

	//dmsLogStateGL();	

	dmsSetGamma(0);
	dmsShutDown();

	// This application is done and we let the Windows know that
	return msg.wParam;
}


bool fadeDemoOut(float &fadeOutTime)
{
		glLoadIdentity();
		dmsPerspective2D(1, 1);

		glDisable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

		const float fadeout = powf(Math::calcPosCos(fadeOutTime, 0, FadeOutMaxTime),2);
		glColor4f(clearcol.x, clearcol.y,clearcol.z, 1-fadeout);
		glBegin(GL_QUADS);
			glVertex2f(0, 0);
			glVertex2f(1, 0);
			glVertex2f(1, 1);
			glVertex2f(0, 1);
		glEnd();
		dmsPerspective3D();
		glLoadIdentity();

		dmsSetVolume(fadeout);
			
		fadeOutTime -= dmsGetDeltaTime();
		glEnable(GL_TEXTURE_2D);

		if(fadeOutTime<=0) 
		{
			return true;
		}
		else 
		{
			return false;
		}
}
