#ifndef _EXTENSION_FUNTIONS_HPP_
#define _EXTENSION_FUNTIONS_HPP_

// VBO 
/*
#define GL_ARRAY_BUFFER_ARB 0x8892
#define GL_STATIC_DRAW_ARB 0x88E4
typedef void (APIENTRY * PFNGLBINDBUFFERARBPROC) (GLenum target, GLuint buffer);
typedef void (APIENTRY * PFNGLDELETEBUFFERSARBPROC) (GLsizei n, const GLuint *buffers);
typedef void (APIENTRY * PFNGLGENBUFFERSARBPROC) (GLsizei n, GLuint *buffers);
typedef void (APIENTRY * PFNGLBUFFERDATAARBPROC) (GLenum target, int size, const GLvoid *data, GLenum usage);
*/

// VBO Extension Function Pointers
PFNGLGENBUFFERSARBPROC					glGenBuffersARB;					// VBO Name Generation Procedure
PFNGLBINDBUFFERARBPROC					glBindBufferARB;					// VBO Bind Procedure
PFNGLBUFFERDATAARBPROC					glBufferDataARB;					// VBO Data Loading Procedure
PFNGLDELETEBUFFERSARBPROC				glDeleteBuffersARB;				// VBO Deletion Procedure

PFNGLMULTITEXCOORD4FARBPROC				glMultiTexCoord4fARB;

PFNGLMULTITEXCOORD2FARBPROC 			glMultiTexCoord2fARB;

PFNGLACTIVETEXTUREARBPROC 			glActiveTextureARB;
PFNGLPOINTPARAMETERFARBPROC 			glPointParameterfARB;
PFNGLPOINTPARAMETERFVARBPROC 			glPointParameterfvARB;
PFNGLISRENDERBUFFEREXTPROC 			glIsRenderbufferEXT;
PFNGLBINDRENDERBUFFEREXTPROC 			glBindRenderbufferEXT;
PFNGLDELETERENDERBUFFERSEXTPROC 		glDeleteRenderbuffersEXT;
PFNGLGENRENDERBUFFERSEXTPROC 			glGenRenderbuffersEXT;
PFNGLRENDERBUFFERSTORAGEEXTPROC 		glRenderbufferStorageEXT;
PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC 		glGetRenderbufferParameterivEXT;
PFNGLISFRAMEBUFFEREXTPROC 			glIsFramebufferEXT;
PFNGLBINDFRAMEBUFFEREXTPROC 			glBindFramebufferEXT;
PFNGLDELETEFRAMEBUFFERSEXTPROC 			glDeleteFramebuffersEXT;
PFNGLGENFRAMEBUFFERSEXTPROC 			glGenFramebuffersEXT;
PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC		glCheckFramebufferStatusEXT;
PFNGLFRAMEBUFFERTEXTURE1DEXTPROC		glFramebufferTexture1DEXT;
PFNGLFRAMEBUFFERTEXTURE2DEXTPROC		glFramebufferTexture2DEXT;
PFNGLFRAMEBUFFERTEXTURE3DEXTPROC		glFramebufferTexture3DEXT;
PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC		glFramebufferRenderbufferEXT;
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC glGetFramebufferAttachmentParameterivEXT;
PFNGLGENERATEMIPMAPEXTPROC			glGenerateMipmapEXT;

PFNGLGETUNIFORMFVPROC				glGetUniformfvARB;
PFNGLGETUNIFORMIVPROC				glGetUniformivARB;

PFNGLCREATEPROGRAMOBJECTARBPROC			glCreateProgramObjectARB;
PFNGLDELETEOBJECTARBPROC			glDeleteObjectARB;
PFNGLCREATESHADEROBJECTARBPROC			glCreateShaderObjectARB;
PFNGLSHADERSOURCEARBPROC			glShaderSourceARB;
PFNGLCOMPILESHADERARBPROC			glCompileShaderARB;
PFNGLGETOBJECTPARAMETERIVARBPROC		glGetObjectParameterivARB;
PFNGLATTACHOBJECTARBPROC			glAttachObjectARB;
PFNGLGETINFOLOGARBPROC				glGetInfoLogARB;
PFNGLLINKPROGRAMARBPROC				glLinkProgramARB;
PFNGLUSEPROGRAMOBJECTARBPROC			glUseProgramObjectARB;
PFNGLGETUNIFORMLOCATIONARBPROC			glGetUniformLocationARB;
PFNGLDELETEPROGRAMPROC				glDeleteProgram;
PFNGLDELETESHADERPROC				glDeleteShader;
PFNGLISPROGRAMPROC				glIsProgram;
PFNGLISSHADERPROC				glIsShader;
PFNGLGETPROGRAMINFOLOGPROC			glGetProgramInfoLog;
PFNGLGETSHADERINFOLOGPROC			glGetShaderInfoLog;

PFNGLUNIFORM4FARBPROC			glUniform4fARB;
PFNGLUNIFORM3FARBPROC			glUniform3fARB;         
PFNGLUNIFORM2FPROC				glUniform2fARB;
PFNGLUNIFORM1FARBPROC			glUniform1fARB;
PFNGLUNIFORM1IARBPROC			glUniform1iARB;

PFNGLUNIFORM1IPROC				glUniform1i;
PFNGLUNIFORM2IPROC				glUniform2i;
PFNGLUNIFORM3IPROC				glUniform3i;
PFNGLUNIFORM4IPROC				glUniform4i;


PFNGLUNIFORM1FVPROC				glUniform1fv;
PFNGLUNIFORM2FVPROC				glUniform2fv;
PFNGLUNIFORM3FVPROC				glUniform3fv;
PFNGLUNIFORM4FVPROC				glUniform4fv;
PFNGLUNIFORM1IVPROC				glUniform1iv;
PFNGLUNIFORM2IVPROC				glUniform2iv;
PFNGLUNIFORM3IVPROC				glUniform3iv;
PFNGLUNIFORM4IVPROC				glUniform4iv;
PFNGLUNIFORMMATRIX2FVPROC		glUniformMatrix2fv;
PFNGLUNIFORMMATRIX3FVPROC		glUniformMatrix3fv;
PFNGLUNIFORMMATRIX4FVPROC		glUniformMatrix4fv;

PFNGLVALIDATEPROGRAMPROC		glValidateProgram;
PFNGLVERTEXATTRIB1DPROC			glVertexAttrib1d;
PFNGLVERTEXATTRIB1DVPROC		glVertexAttrib1dv;
PFNGLVERTEXATTRIB1FPROC			glVertexAttrib1f;
PFNGLVERTEXATTRIB1FVPROC		glVertexAttrib1fv;
PFNGLVERTEXATTRIB1SPROC			glVertexAttrib1s;
PFNGLVERTEXATTRIB1SVPROC		glVertexAttrib1sv;
PFNGLVERTEXATTRIB2DPROC			glVertexAttrib2d;
PFNGLVERTEXATTRIB2DVPROC		glVertexAttrib2dv;
PFNGLVERTEXATTRIB2FPROC			glVertexAttrib2f;
PFNGLVERTEXATTRIB2FVPROC		glVertexAttrib2fv;
PFNGLVERTEXATTRIB2SPROC			glVertexAttrib2s;
PFNGLVERTEXATTRIB2SVPROC		glVertexAttrib2sv;
PFNGLVERTEXATTRIB3DPROC			glVertexAttrib3d;
PFNGLVERTEXATTRIB3DVPROC		glVertexAttrib3dv;
PFNGLVERTEXATTRIB3FPROC			glVertexAttrib3f;
PFNGLVERTEXATTRIB3FVPROC		glVertexAttrib3fv;
PFNGLVERTEXATTRIB3SPROC			glVertexAttrib3s;
PFNGLVERTEXATTRIB3SVPROC		glVertexAttrib3sv;
PFNGLVERTEXATTRIB4NBVPROC		glVertexAttrib4Nbv;
PFNGLVERTEXATTRIB4NIVPROC		glVertexAttrib4Niv;
PFNGLVERTEXATTRIB4NSVPROC		glVertexAttrib4Nsv;
PFNGLVERTEXATTRIB4NUBPROC		glVertexAttrib4Nub;
PFNGLVERTEXATTRIB4NUBVPROC		glVertexAttrib4Nubv;
PFNGLVERTEXATTRIB4NUIVPROC		glVertexAttrib4Nuiv;
PFNGLVERTEXATTRIB4NUSVPROC		glVertexAttrib4Nusv;
PFNGLVERTEXATTRIB4BVPROC		glVertexAttrib4bv;
PFNGLVERTEXATTRIB4DPROC			glVertexAttrib4d;
PFNGLVERTEXATTRIB4DVPROC		glVertexAttrib4dv;
PFNGLVERTEXATTRIB4FPROC			glVertexAttrib4f;
PFNGLVERTEXATTRIB4FVPROC		glVertexAttrib4fv;
PFNGLVERTEXATTRIB4IVPROC		glVertexAttrib4iv;

/*
// These random functions did not function properly for some reason - atleast on my atiR9800
PFNGLVERTEXATTRIB4SPROC			glVertexAttrib4s;
PFNGLVERTEXATTRIB4SVPROC		glVertexAttrib4sv;
PFNGLVERTEXATTRIB4UBVPROC		glVertexAttrib4ubv;
PFNGLVERTEXATTRIB4UIVPROC		glVertexAttrib4uiv;
PFNGLVERTEXATTRIB4USVPROC		glVertexAttrib4us;
*/
PFNGLVERTEXATTRIBPOINTERPROC	glVertexAttribPointer;

#endif