#ifndef _Virtaus_HPP_
#define _Virtaus_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"

class VirtausNode
{
public:
    Vector3 startpos;
    Vector3 position;
    Vector3 speed;
    float originaldist;

};

class VirtausSpline
{
public:
    void generate(Vector3 &start, Vector3 &end);
    void draw(float alpha);
    void update();

    float fade;
    int nodecount;
    VirtausNode *nodes;
    CatmullRom *spline;
    Vector3 color;
    float phase;
    

};
class Virtaus : public Base
{
	public:

		Virtaus();
		~Virtaus();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
        FrameTimer *frametimer;
        int count;
        VirtausSpline **splines;
		void renderScene(float pos, float alpha);
};

#endif

 