	
#ifdef _DEBUG
	#include <stdlib.h>
	//#include "../mmgr.h"
#endif

#pragma warning(disable: 4244)

#include <math.h>

#include "stream.h"
#include "../Mathematics.hpp"
#include "../primitives.hpp"

void Stream::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.00f;
	const float fadeinstop = 0.45f;
	const float fadeoutstart = 0.85f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);
	
	if(pos >= fadeoutstop || pos < fadeinstart)
		alpha = 0;

	renderScene(pos, alpha);

}

void RenderWaterPlane(float y)
{
	// Render quad
	glBegin(GL_QUADS);
		glTexCoord2f(1.0f, 1.0f);
		glVertex3f(300.0f, y, 300.0f);

		glTexCoord2f(1.0f, 0.0f);
		glVertex3f(300.0f, y, -300.0f);

		glTexCoord2f(0.0f, 0.0f);
		glVertex3f(-300.0f, y, -300.0f);

		glTexCoord2f(0.0f, 1.0f);
		glVertex3f(-300.0f, y, 300.0f);
	glEnd();
}

Vector turbulenceFunc1(float t,Vector &pos)
{
    const float m = 1.8f;

    const float x = 0.7f*cosf(pos.x*m*t*12)+1.1f*sinf(pos.y*m*t*8)+0.52f*cosf(pos.z*m*t*17); 
    const float y = 0.9f*cosf(pos.x*m*t*19)+1.6f*sinf((pos.y-0.6f*pos.x)*m*t*18)+1.22f*cosf(pos.z*m*t*6); 
    const float z = 1.4f*cosf(pos.x*m*t*9)+0.98f*sinf(pos.y*m*t*12)+1.42f*cosf((pos.z-0.6f*pos.x)*m*t*6); 

    return Vector(x, y, z);

}

void Stream::drawParticles(float pos, float alpha)
{

	int i;
//	glTranslatef(-2.5, 0, -2.5);


	Vector3 x, y, z;
	Math::antiRotate(&x, &y, &z);

	
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);
	glDisable(GL_DEPTH_TEST);


	const int sm = smokeCount/4;
	for(i=0; i<smokeCount; i++)
	{

		//Vector adjust = turbulenceFunc1(pos, smoke[i])*0.00172f;
		Vector adjust = Vector(0, (16-(i&31))*0.0059f, (16-(i&31))*0.00259f);

		smoke[i] += Vector(0.095f*(fmodf(i, 1.5f) - 0.75f), adjust.z, adjust.y) * dmsGetDeltaTime() * 1.75f;

		Vector point = smoke[i];
		const float size = 2.5f;
		//const float size = 1.0750f;


		if(i==0)   		 glBindTexture(GL_TEXTURE_2D, dmsGetTexture("smoke1.jpg")->getID());
		else if(i==sm)   glBindTexture(GL_TEXTURE_2D, dmsGetTexture("smoke2.jpg")->getID());
		else if(i==sm*2) glBindTexture(GL_TEXTURE_2D, dmsGetTexture("smoke3.jpg")->getID());
		else if(i==sm*3) glBindTexture(GL_TEXTURE_2D, dmsGetTexture("smoke4.jpg")->getID());

		glColor3f(0.09713f*alpha,0.09713f*alpha,((i%4)*0.0173f + 0.09239713f)*alpha);

		glBegin(GL_QUADS);

			Vector v1 = point - x*size - y*size;
			Vector v2 = point + x*size - y*size;
			Vector v3 = point + x*size + y*size;
			Vector v4 = point - x*size + y*size;

			glTexCoord2f(0, 0);
			glVertex3fv((float *)&v1);
			glTexCoord2f(1, 0);
			glVertex3fv((float *)&v2);
			glTexCoord2f(1, 1);
			glVertex3fv((float *)&v3);
			glTexCoord2f(0, 1);
			glVertex3fv((float *)&v4);

		glEnd();
	}

	float col = 0.0175f*alpha;//tool->getValue("slider5");
	glColor3f(col, col, col);
	//const int small = smallSmokeCount/4;
	glBindTexture(GL_TEXTURE_2D, dmsGetTexture("smoke3.jpg")->getID());
	
	const float size = 0.075f;
	Vector xsize = x*size;
	Vector ysize = y*size;
	glBegin(GL_QUADS);
	for(i=0; i<smallSmokeCount; i++)
	{

		Vector point = smallsmoke[i];

			Vector v1 = point - xsize - ysize;
			Vector v2 = point + xsize - ysize;
			Vector v3 = point + xsize + ysize;
			Vector v4 = point - xsize + ysize;

			glTexCoord2f(0, 0);
			glVertex3fv((float *)&v1);
			glTexCoord2f(1, 0);
			glVertex3fv((float *)&v2);
			glTexCoord2f(1, 1);
			glVertex3fv((float *)&v3);
			glTexCoord2f(0, 1);
			glVertex3fv((float *)&v4);

	}
	glEnd();

/**/
	glDisable(GL_BLEND);
}


bool lookAt( float pos )
{
	
	Vector3 cam = Vector3(3.90f, 1.0319729724f, 4.29f);
	cam -= Vector3(3.00f, 0, 3.00f) * pos * pos * pos;
	cam -= Vector3(0.0f, 1.20f, 0.0f) * pos * pos * pos;

	if(cam.y < 0.001f) return false;

	Vector3 to = Vector3(0,0.0f,0);
	//to.z -= pos*pos*0.6f;

	Vector3 up = Vector3(0,1,0) + Vector3(1,0,0)*powf(Math::calcPosFloat(pos, 0.9f, 1.0f),3);
	up.normalize();

	gluLookAt( cam.x, cam.y, cam.z,
				to.x, to.y, to.z,
				up.x, up.y, up.z);

	return true;
}

void Stream::RenderReflection(float pos, float alpha)
{
	glExt.bindTextureFBO512(glExt.glowTexture512ID);

		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		lookAt(pos);

		glPushMatrix();
		glTranslatef(0.0f, 0.0f, 0.0f);
		glScalef(1.0, -1.0, 1.0);
		double plane[4] = {0.0, 1.0, 0.0, 0.0}; //water at y=0
		glEnable(GL_CLIP_PLANE0);
		glClipPlane(GL_CLIP_PLANE0, plane);
			drawParticles(pos, alpha);
		glDisable(GL_CLIP_PLANE0);
		glPopMatrix();

	glExt.unbindFBO();
}

void Stream::RenderRefractionAndDepth(float pos, float alpha)
{
    glExt.bindDepthFBO();

		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		lookAt(pos);

		glPushMatrix();
		glTranslatef(0.0f, 0.0f, 0.0f);
		//normal pointing along negative y
		double plane[4] = {0.0, -1.0, 0.0, 0.0};
		glEnable(GL_CLIP_PLANE0);
		glClipPlane(GL_CLIP_PLANE0, plane);
			drawParticles(pos, alpha);
		glDisable(GL_CLIP_PLANE0);
		glPopMatrix();

	glExt.unbindFBO();
}

void Stream::RenderWater(float pos, float alpha)
{

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	Shader *waterReflect = shaders->getShader("waterRefl");
	waterReflect->bind();

	//waterReflect->setUniform1f("fade",  alpha*alpha*alpha);	// time!

	const float spdmod = pos * 0.1f;

	waterReflect->setUniform1f("time",  4.5f*spdmod);	// time!
	waterReflect->setUniform1f("time2", 7.0f*spdmod);
	
	waterReflect->setUniform4f("viewpos", 1, 1, 1 ,1);
	//waterReflect->setUniform4f("lightpos", -209.5, 1, 7.5, 1);

	waterReflect->setUniform4f("waterColor", 0.1773f*alpha, 0.2604163f*alpha, 0.3156f*alpha, 1.0f*alpha);

	glColor3f(1,1,1);

    glActiveTextureARB(GL_TEXTURE0_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID);
	waterReflect->setUniform1i("water_reflection", 0);

    glActiveTextureARB(GL_TEXTURE1_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, glExt.depthColTex); //refraction
	waterReflect->setUniform1i("water_refraction", 1);

    glActiveTextureARB(GL_TEXTURE2_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("water_normalmap.jpg")->getID());
	waterReflect->setUniform1i("water_normalmap", 2);

    glActiveTextureARB(GL_TEXTURE3_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("water_distort.jpg")->getID());
	waterReflect->setUniform1i("water_dudvmap", 3);

    glActiveTextureARB(GL_TEXTURE4_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, glExt.depthTex);
	waterReflect->setUniform1i("water_depthmap", 4);

    glActiveTextureARB(GL_TEXTURE5_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("envmap.jpg")->getID());
	waterReflect->setUniform1i("water_envmap", 5);

    glBegin(GL_QUADS);
    glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 0.0f, 5.0f);
    glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0.0f, 1.0f);
    glMultiTexCoord2fARB(GL_TEXTURE2_ARB, 0.0f, 1.0f);
    glMultiTexCoord2fARB(GL_TEXTURE3_ARB, 0.0f, 1.0f);
    glMultiTexCoord2fARB(GL_TEXTURE4_ARB, 0.0f, 1.0f);
    glVertex3f(-5.0f, 0.0f, 5.0f);
    glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 0.0f, 0.0f);
    glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0.0f, 0.0f);
    glMultiTexCoord2fARB(GL_TEXTURE2_ARB, 0.0f, 0.0f);
    glMultiTexCoord2fARB(GL_TEXTURE3_ARB, 0.0f, 0.0f);
    glMultiTexCoord2fARB(GL_TEXTURE4_ARB, 0.0f, 0.0f);
    glVertex3f(-5.0f, 0.0f, -5.0f);
    glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 5.0f, 0.0f);
    glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 1.0f, 0.0f);
    glMultiTexCoord2fARB(GL_TEXTURE2_ARB, 1.0f, 0.0f);
    glMultiTexCoord2fARB(GL_TEXTURE3_ARB, 1.0f, 0.0f);
    glMultiTexCoord2fARB(GL_TEXTURE4_ARB, 1.0f, 0.0f);
    glVertex3f(5.0f, 0.0f, -5.0f);
    glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 5.0f, 5.0f);
    glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 1.0f, 1.0f);
    glMultiTexCoord2fARB(GL_TEXTURE2_ARB, 1.0f, 1.0f);
    glMultiTexCoord2fARB(GL_TEXTURE3_ARB, 1.0f, 1.0f);
    glMultiTexCoord2fARB(GL_TEXTURE4_ARB, 1.0f, 1.0f);
    glVertex3f(5.0f, 0.0f, 5.0f);
    glEnd();
	
    glActiveTextureARB(GL_TEXTURE0_ARB);
    glDisable(GL_TEXTURE_2D);

    glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);

    glActiveTextureARB(GL_TEXTURE2_ARB);
	glDisable(GL_TEXTURE_2D);

    glActiveTextureARB(GL_TEXTURE3_ARB);
	glDisable(GL_TEXTURE_2D);

    glActiveTextureARB(GL_TEXTURE4_ARB);
    glDisable(GL_TEXTURE_2D);

    glActiveTextureARB(GL_TEXTURE5_ARB);
    glDisable(GL_TEXTURE_2D);

	glActiveTextureARB(GL_TEXTURE0_ARB);

	waterReflect->unbind();

}

void Stream::renderScene(float pos, float alpha)
{

	glLoadIdentity();
	if(!lookAt(pos )) return;

	drawParticles(pos, alpha);

    RenderReflection(pos, alpha);
     RenderRefractionAndDepth(pos, alpha);

    //reset viewport to screensize
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glLoadIdentity();

	lookAt(pos);

//	filter.init();
	glEnable(GL_DEPTH_TEST);

		RenderWater(pos, alpha);

		drawParticles(pos, alpha);


	glDisable(GL_DEPTH_TEST);
//	filter.glow(3, 0.004f, 0.004f, 1.0f, 0.98f);





}	


Stream::Stream()
{	
    int i;

    srand(1);

	smokeCount = 80;
	smoke = new Vector[smokeCount];
	for(i=0; i<smokeCount; i++)
	{
		float x = Math::randBetween( 0.1f,	-20.0f);
		float y = Math::randBetween( 0.52f,  4.5f);
		float z = Math::randBetween( 0.1f,	-20.0f);
		smoke[i] = Vector(x,y,z);
	}


	const float radius = 3.25f;
	smallSmokeCount = 500;
	smallsmoke = new Vector[smallSmokeCount];
	for(i=0; i<smallSmokeCount; i++)
	{
		float x = Math::randBetween( radius,	-radius);
		float y = Math::randBetween( 0.000001f,  0.0005f);
		float z = Math::randBetween( radius,	-radius);
		smallsmoke[i] = Vector(x,y,z);
	}
}

Stream::~Stream()
{

}


bool Stream::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

