#ifndef _Ravintoketju_HPP_
#define _Ravintoketju_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "../boundedmovement.h"

#define RUOKA_STATE_BIRTH 1
#define RUOKA_STATE_SWIM 2
#define RUOKA_STATE_DYING 3
#define RUOKA_STATE_DEAD 4

class Ruoka
{
    friend class Peto; //:D 
public:
    void init(bool beginning);
    void update(int petocount, class Peto *pedot);
    void draw(float alpha);
    Vector3 getPosition();

    int state;
private:
    BoundedMovement movement;
    float timer;
    float fade;
};

#define PETO_STATE_WANDER 1
#define PETO_STATE_HUNT 2

class Peto
{
    friend class Ruoka;
public:
    void init();
    void update(int ruokacount, class Ruoka *ruoat);
    void draw(float alpha);

    BoundedMovement movement;
private:
    int state;
    class Ruoka *target;

};

class Ravintoketju : public Base
{
	public:

		Ravintoketju();
		~Ravintoketju();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private: 
        int ruokacount;
        Ruoka *ruoat;

        int petocount;
        Peto *pedot;

        FrameTimer *frametimer;
		void renderScene(float pos, float alpha);
};

#endif

 