#ifndef _Oliot_HPP_
#define _Oliot_HPP_

#include <stdio.h>
#include <list>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "../groundplane.hpp"
#include "../boundedmovement.h"
#include "../cubemap.hpp"

////////////////////////////////////////////////////////////////////////////////////////
//                                      KAMPA
////////////////////////////////////////////////////////////////////////////////////////
class KampaOlio
{
public:
    KampaOlio() {};
    ~KampaOlio() {};

    void init();
    void update();
    void draw(float alpha);

private:
    float aika;
    float speed;
    float length, width;
    int spikes;
    Vector3 position;
    Vector3 orientation;
    Vector3 color;
    Vector3 velocity;
    Vector3 rotation;

    void initVelocity();

    bool special;

    Vector3 *leftside;
    Vector3 *rightside;
    float *sizes;
    Texture *texture;

    void drawValo(Vector3 &pos, Vector3 &xr, Vector3 &yr, Vector3 &zr, float size, float alpha);
};
////////////////////////////////////////////////////////////////////////////////////////
//                                      RIHMA
////////////////////////////////////////////////////////////////////////////////////////

class RihmaOlio
{
public:
    RihmaOlio() {};
    ~RihmaOlio() {};

    void init();
    void update(float pos);
    void draw(float pos, float alpha);
    void draw2(Vector3 &xr, Vector3 &yr, Vector3 &zr, float pos, float alpha);
    void draw3(Vector3 &xr, Vector3 &yr, Vector3 &zr, float pos, float alpha);


private:
    float t, t2;
    float speed;
    float phase;
    Vector3 valoPosition;
    void drawValo(Vector3 &pos, Vector3 &xr, Vector3 &yr, Vector3 &zr, float size, float alpha);
    float st, et;
    float st2, et2;
    CatmullRom *path;
    Vector3 position;
    Vector3 color;
};
////////////////////////////////////////////////////////////////////////////////////////
//                                      LiIKKUVA
////////////////////////////////////////////////////////////////////////////////////////

class LiikkuvaOlio
{
public:
    LiikkuvaOlio() {};
    ~LiikkuvaOlio() {};

    void init();
    void update();
    void draw(float alpha, float ymove=0.0f);
    void turn();

    float phase;
    float phasespeed;
    Vector3 color;
    BoundedMovement movement;

};
////////////////////////////////////////////////////////////////////////////////////////
//                                      SIILI
////////////////////////////////////////////////////////////////////////////////////////

class SiilinPiikki
{

};

class SiiliOlio
{
public:

};

////////////////////////////////////////////////////////////////////////////////////////
//                                      KIMALLE
////////////////////////////////////////////////////////////////////////////////////////

class Kimalle
{
public:
    Kimalle();
    ~Kimalle();

    void init();
    void update(float pos);
    void draw1(float alpha);
    void draw2(Vector3 &xr, Vector3 &yr, Vector3 &zr, float alpha);

private:
    float st, et;
    float phase;
    float speed;

    CatmullRom *path;
    float glow;
    float glowspeed;
    float self_t;
    float fade;
    float basefade;

};
////////////////////////////////////////////////////////////////////////////////////////
//                                      EFEKTI
////////////////////////////////////////////////////////////////////////////////////////

class Oliot : public Base
{
	public:

		Oliot();
		~Oliot();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:

        Cubemap *cubemap;
        int kampacount;
        KampaOlio *kammat;
        int rihmacount;
        RihmaOlio *rihmat;
        

        std::vector<Kimalle> kimalteet;


        TMesh *mesh;

        GroundPlane *merenpohja;
        FrameTimer *frametimer;
        void renderGeometry(float pos, float alpha);
		void renderScene(float pos, float alpha);
};

#endif

 