#ifndef _Nilviaiset_HPP_
#define _Nilviaiset_HPP_

#include <stdio.h>
#include <list>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "../groundplane.hpp"


class Nilviainen
{
public:
    virtual void init() {};
    virtual void free() {};
    virtual void draw(float alpha) {};
    virtual void update() {};
    virtual bool isDead() { return false; };


};

class SpiraaliOtus : public Nilviainen
{
public:
    void init();
    void free();
    void draw(float alpha);
    void update();
    bool isDead();
private:
    Vector3 position;
    Vector3 rotation;
    Vector3 color;
    CatmullRom *spline;
    CatmullRom *spline2;
};

class Kasvinauha
{
public:
    void init(Vector3 &color, Vector3 &startpos);

    CatmullRom *spline;
    Vector3 color;

};


class Pohjakasvi : public Nilviainen
{
public:
    void init();
    void free();
    void draw(float alpha);
    void update();
    bool isDead();

private:
    float time;
    std::vector<Kasvinauha> nauhat;


};



class Nilviaiset : public Base
{
	public:

		Nilviaiset();
		~Nilviaiset();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
        std::list<class SpiraaliOtus> otukset;
        std::list<class Pohjakasvi> kasvit;
        GroundPlane *merenpohja;
        FrameTimer *frametimer;
		void renderScene(float pos, float alpha);
};

#endif

 