#ifndef _Maailma_HPP_
#define _Maailma_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "../groundplane.hpp"

class MaailmaItem
{
    public:

        MaailmaItem();
        ~MaailmaItem();
        void init();
        void setMesh(TMesh *m) { this->mesh = m; }
        void draw(float alpha);
        void update();

    private:
        float animationspeed;
        float animation;
        float scale;
        float fade;

        TMesh *mesh;
        Vector3 position;
        Vector3 direction;


};

class Maailma : public Base
{
	public:

		Maailma();
		~Maailma();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private: 
        GroundPlane *merenpohja;
        std::vector<MaailmaItem> items;
        TMesh *mesh;
        FrameTimer *frametimer;
		void renderScene(float pos, float alpha);
};

#endif

 