#ifndef _GUIELEMENT_H_
#define _GUIELEMENT_H_

#include <string>
//#include "SDL_opengl.h"
#include "./tinyxml/tinyxml.h"
#include "GUIInclude.h"
#include "GUIEvent.h"

class GUIHolder;
class GUIElement 
{
	friend class GUIHolder;
public:
	
	GUIElement() {};
	GUIElement(int x, int y, int w, int h, const char *callback);
	~GUIElement();

	bool focused;
	bool hover;

	virtual void render(float dt);
	
	virtual std::string checkMouseMovedEvents(GUIMouseMovedEvent &me);
	virtual std::string checkMousePressedEvents(GUIMousePressedEvent &me);	
	virtual std::string checkKeyboardEvents(GUIKeyboardEvent &me);	

	virtual void setHolderPointer(GUIHolder *holder);

	virtual void setCenter(int x, int y);

	int x,y;			// position
	int w,h;			// width height

	std::string getCallback() { return this->callback; }

	bool operator == (GUIElement const &elem);

	virtual void setColor(float _r, float _g, float _b);

	virtual void writeToXml(TiXmlElement *parent) = 0;
	virtual void loadElement(TiXmlElement * pParent) = 0;

	virtual int getWidgetType();

protected:

	float r,g,b;

	int widgetType;		
	std::string callback;		// nimi jonka tm palauttaa actionlistenerille
	bool isHit(int x_, int y_);
	GUIHolder *holder;
};


#endif