#ifndef _TEXTMANAGER_HPP_
#define _TEXTMANAGER_HPP_

//--------------------------------------------------------------------------------------------
//  Headers
//--------------------------------------------------------------------------------------------

#include "font.hpp"
#include "list.hpp"

#include <iostream>
#include <fstream>
using namespace std;

//--------------------------------------------------------------------------------------------
//  This code belongs to our library namespace: TRACTION_DEMOTRACTOR
//--------------------------------------------------------------------------------------------

namespace TRACTION_DEMOTRACTOR
{

//--------------------------------------------------------------------------------------------
//  Singleton TextManager class
//--------------------------------------------------------------------------------------------

	class TextManager
	{
		public:

			~TextManager();			

			// luonti funktio jolla varmistetaan ett luokasta on vain
			// YKSI instanssi olemassa
			static TextManager *create();
			
			void debug();
			void release();

			// Getters
			unsigned int getTextCount();
			std::string *getText(unsigned int index);
			std::string *getTextName(char *filename);
			bool addText(char *filename, std::string text);
			bool addText(char *filename, const char *text, int len);
			bool addTextFromFile(char *fname, char *name);
			
			
		private:

			static bool createdFlag;			// true jos yksi instanssi olemassa
			static TextManager *instance;

			unsigned int nTexts;
			List <std::string> texts; // TODO: Char *

			// kun nm on privatena niin voidaan est uusien ilmentymien luonti
			TextManager();
			TextManager(const TextManager&) {}
			TextManager& operator = (const TextManager&) {}
	};

}

#endif