#include "stdafx.h"

#ifndef _DEMO

#define TABCHAR 'm'
#define TABNUMSPACE 4

///////////////////////////////////////// core::g-> data
int palinit=1;
Font Fonts[F_NUM];
__int64 font8[256][8];
__int64 font8side[256][8];
int pal16[256];
	int ver;
	
UBYTE ctab[256];
unsigned int ocol;
unsigned int ocolon;
char *vubits;
	char *vubitsv;
	
	int bkc;
	int canvasx,canvasy;
/////////////////////////////////////////////////////////	

struct PalInfo
{
	BITMAPINFOHEADER h;
	RGBQUAD pal[256];
} thepal;


void AlexDC::Rect3D(int x1, int y1, int x2, int y2, int c, bool down, bool fill) // takes 32 bit colours!!
{
	if (fill) FillRect(x1,y1,x2,y2,C32TO8(c));
	int cc=INTERP(c,0,128);	
	Rect(x1,y1,x2,y2,C32TO8(cc));
	x1++;y1++;x2--;y2--;
	int c1=INTERP(c,0,64);
	int c2=INTERP(c,0xffffff,128);
	c1=C32TO8(c1);
	c2=C32TO8(c2);
	c =C32TO8(c);
	if (down)
	{
		Line(x1,y1,x2+1,y1,c1);
		Line(x1,y2,x2+1,y2,c);
		Line(x1,y1+1,x1,y2,c1);
		Line(x2,y1+1,x2,y2,c);
	}
	else
	{
		Line(x1,y1,x2+1,y1,c2);
		Line(x1,y2,x2+1,y2,c1);
		Line(x1,y1+1,x1,y2,c2);
		Line(x2,y1+1,x2,y2,c1);
	}		
}

void AlexDC::CreateBMP(HDC dc)
{	
	KillBMP();
	int w=this->w + ncx1 + ncx2;
	int h=this->h + ncy1 + ncy2;
	if (w>2048) w=2048;
	if (h>2048) h=2048;
	p=(w+3)&~3;
	p=2048;
	if (palinit)
	{
		palinit=0;
	
		memset(&thepal,0,sizeof(thepal));
		FILE *f=0?fopen("c:\\bs.act","wb"):NULL;
		for (int c1=0;c1<256;c1++)
		{
#ifdef RGB332
			int rr= thepal.pal[c1].rgbRed  =(((c1>>0)&7)*255)/7;
			int gg= thepal.pal[c1].rgbGreen=(((c1>>3)&7)*255)/7;
			int bb= thepal.pal[c1].rgbBlue =(((c1>>6)&3)*255)/3;
			rr>>=3;
			gg>>=2;
			bb>>=3;
			pal16[c1]=(rr<<11)+(gg<5)+(bb<<0);
#else
			int rr= thepal.pal[c1].rgbRed  =(((c1>>0)&3)*255)/3;
			int gg= thepal.pal[c1].rgbGreen=(((c1>>2)&3)*255)/3;
			int bb= thepal.pal[c1].rgbBlue =(((c1>>4)&3)*255)/3;
			rr>>=3;
			gg>>=2;
			bb>>=3;
			pal16[c1]=(rr<<11)+(gg<5)+(bb<<0);
#endif

			if (f) fwrite(&thepal.pal[c1].rgbRed,1,1,f);
			if (f) fwrite(&thepal.pal[c1].rgbGreen,1,1,f);
			if (f) fwrite(&thepal.pal[c1].rgbBlue,1,1,f);
		}
		if (f) fclose(f);
	}
	thepal.h.biSize=sizeof(BITMAPINFOHEADER);
	thepal.h.biWidth=2048;
	thepal.h.biHeight=-2048;
	thepal.h.biPlanes=1;
	thepal.h.biBitCount=8;
	thepal.h.biCompression=BI_RGB;
	thepal.h.biClrUsed=256;

			
	if (!hb)
	{
		hb=CreateDIBSection(0,(BITMAPINFO*)&thepal,DIB_RGB_COLORS,(void**)&dst,NULL,0);	
		xdst=dst;
		dst+=p*ncy1+ncx1;
	}
		
	ResetScans();
	//left=new int[h];
	//right=new int[h];
	//for (int c1=0;c1<h;c1++) left[c1]=c1;
	//for (c1=0;c1<h;c1++) right[c1]=-c1;
}

void AlexDC::AddEdge(int x1, int y1, int x2, int y2)
{
	if (y1==y2) return;
	int *dst;
	if (y1>y2)
	{
		dst=left;
		int t=y1;y1=y2;y2=t;
		t=x1;x1=x2;x2=t;
	}
	else
	{
		dst=right;
	}
	float grad=(x2-x1)/float(y2-y1);
	if (y2>cy2) y2=cy2;
	if (y1<cy1)
	{
		x1+=int((cy1-y1)*grad);
		y1=cy1;
	}
	if (y2>cy2) y2=cy2;
	if (y1>=y2) return;
	if (y1<miny) miny=y1;
	if (y2>maxy) maxy=y2;	
	float cx=x1;
	dst+=y1;
	for (;y1<y2;y1++,cx+=grad) *dst++ = int(cx);
}

void AlexDC::FillScans(int c)
{
	miny=bound(cy1,miny,cy2);
	maxy=bound(cy1,maxy,cy2);
	for (int y=miny;y<maxy;y++)
	{
		int x1=left[y];
		int x2=right[y];
		if (x1>x2)
		{
			int t=x1;x1=x2;x2=t;
		}
		x1=bound(cx1,x1,cx2);
		x2=bound(cx1,x2,cx2);
		if (x1<x2)
		{
			UBYTE *d2=dst+y*p+x1;
			memset(d2,c,x2-x1);
		}
	}
}

void AlexDC::FatLine(int x1, int y1, int x2, int y2, int c, int oc)
{
	if (oc<0) oc=c;
	if (abs(x2-x1)>=abs(y2-y1))
	{
		// nearly horiz
		Line(x1,y1,x2,y2,c);
		Line(x1,y1-1,x2,y2-1,oc);
		Line(x1,y1+1,x2,y2+1,oc);
	}
	else
	{
		Line(x1,y1,x2,y2,c);
		Line(x1-1,y1,x2-1,y2,oc);
		Line(x1+1,y1,x2+1,y2,oc);
	}
}

void AlexDC::Line(int x1, int y1, int x2, int y2, int c)
{
	if (x1==x2) VLine(x1,y1,y2,c); else
	if (y1==y2) HLine(x1,y1,x2,c); else
	{
		int oc1=0;
		int oc2=0;
		do
		{
			oc1=oc2=0;
			if (x1<cx1) oc1|=1; else if (x1>cx2) oc1|=2;if (y1<cy1) oc1|=4; else if (y1>cy2) oc1|=8;
			if (x2<cx1) oc2|=1; else if (x2>cx2) oc2|=2;if (y2<cy1) oc2|=4; else if (y2>cy2) oc2|=8;			
			if (oc1 & oc2) return;
			oc1^=oc2;
			if (!oc1) break;
			if ((oc1&1) && (x2!=x1))
			{
				float f=1-(x2-cx1)/float(x2-x1);
				if (x1<cx1) 
				{
					x1=cx1;y1=y1+f*(y2-y1); 
				}
				else
				{
					x2=cx1;y2=y1+f*(y2-y1); 
				}
			}
			else if ((oc1&2) && (x2!=x1))
			{
				float f=1-(x2-cx2)/float(x2-x1);
				if (x1>cx2) 
				{
					x1=cx2;y1=y1+f*(y2-y1); 
				}
				else
				{
					x2=cx2;y2=y1+f*(y2-y1); 
				}
			}
			else if ((oc1&4) && (y2!=y1))
			{
				float f=1-(y2-cy1)/float(y2-y1);
				if (y1<cy1) 
				{
					y1=cy1;x1=x1+f*(x2-x1); 
				}
				else
				{
					y2=cy1;x2=x1+f*(x2-x1); 
				}
			}
			else if ((oc1&8) && (y2!=y1))
			{
				float f=1-(y2-cy2)/float(y2-y1);
				if (y1>cy2) 
				{
					y1=cy2;x1=x1+f*(x2-x1); 
				}
				else
				{
					y2=cy2;x2=x1+f*(x2-x1); 
				}
			}			
		} while (oc1);
		// draw line!
		y2-=y1;
		x2-=x1;
		if (abs(x2)>=abs(y2))
		{
			// mostly horiz
			if (x2==0) return;
			if (x2<0)
			{
				x2=-x2;
				y2=-y2;
				x1-=x2;
				y1-=y2;
			}		
			UBYTE *d=dst+y1*p+x1;
			int a=0,da=(y2<<16)/x2;
			for (;x2>0;x2--,d++,a+=da) d[(a>>16)*p]=c;							
		}
		else 
		{
			// mostly vert
			if (y2==0) return;
			if (y2<0)
			{
				x2=-x2;
				y2=-y2;
				x1-=x2;
				y1-=y2;
			}		
			UBYTE *d=dst+y1*p+x1;
			int a=0,da=(x2<<16)/y2;
			for (;y2>0;y2--,d+=p,a+=da) d[(a>>16)]=c;							
		}		
	}
}

void AlexDC::HLine(int x1, int y1, int x2, int c)
{
	if (y1<cy1 || y1>=cy2) return;
	if (x1>x2) 
	{
		int t=x1;x1=x2;x2=t;
	}
	x1=bound(cx1,x1,cx2);
	x2=bound(cx1,x2,cx2);
	if (x1<x2)
	{
		UBYTE *d2=dst+y1*p+x1;
		memset(d2,c,x2-x1);
	}
}

void AlexDC::VLine(int x1, int y1, int y2, int c)
{
	if (x1<cx1 || x1>=cx2) return;
	if (y1>y2) 
	{
		int t=y1;y1=y2;y2=t;
	}
	y1=bound(cy1,y1,cy2);
	y2=bound(cy1,y2,cy2);
	if (y1<y2)
	{
		UBYTE *d2=dst+y1*p+x1;
		for (;y1<y2;y1++,d2+=p) *d2=c;
	}
}

void AlexDC::DrawHMeter(int x1, int y1, float level)
{
	level=bound(0,level,1);
	if (!vubits)
	{
		FILE *f=fopen("data\\meterh.raw","rb");
		if (f)
		{
			vubits=new char[128*24];
			fread(vubits,128,24,f);
			fclose(f);
		}
	}
	if (vubits)
	{
		int x3=int(level*128);
		int x2=x1+128;
		CopyBits(x1,y1,x1+x3,y1+12,vubits,0,0,128,24);
		CopyBits(x1+x3,y1,x2,y1+12,vubits,x3,12,128,24);
	}
	
}

void AlexDC::DrawVMeter(int x1, int y1, float level)
{
	level=bound(0,level,1);
	if (!vubitsv)
	{
		FILE *f=fopen("data\\meterv.raw","rb");
		if (f)
		{
			vubitsv=new char[48*24];
			fread(vubitsv,48,24,f);
			fclose(f);
		}
	}
	if (vubitsv)
	{
		int y3=int((1-level)*48);
		int y2=y1+48;
		CopyBits(x1,y1,x1+12,y1+y3,vubitsv,12,0,24,48);
		CopyBits(x1,y1+y3,x1+12,y2,vubitsv,0,y3,24,48);		
	}
	
}

void AlexDC::CopyBits(int x1, int y1, int x2, int y2, char *src, int srcx, int srcy, int srcw, int srch)
{	
	if (!dst || !src) return;
	if (x1>x2) 
	{
		int t=x1;x1=x2;x2=t;
	}
	if (y1>y2) 
	{
		int t=y1;y1=y2;y2=t;
	}
	int ox1=x1;
	int oy1=y1;
	x1=bound(cx1,x1,cx2);y1=bound(cy1,y1,cy2);
	x2=bound(cx1,x2,cx2);y2=bound(cy1,y2,cy2);
	srcx+=x1-ox1;
	srcy+=y1-oy1;
	if (srcx<0) x1-=srcx;
	if (srcy<0) y1-=srcy;
	if (srcx+x2-x1>srcw) x2-= srcx+x2-x1-srcw;
	if (srcy+y2-y1>srch) y2-= srcy+y2-y1-srch;
	if (x1>=x2 || y1>=y2) return;

	src+=srcx+srcw*srcy;
	
	UBYTE *d2=dst+y1*p+x1;
	x2-=x1;
	for (;y1<y2;y1++,d2+=p,src+=srcw) memcpy(d2,src,x2);		
}

void AlexDC::FillRect(int x1, int y1, int x2, int y2, int c)
{
	if (x1>x2) 
	{
		int t=x1;x1=x2;x2=t;
	}
	if (y1>y2) 
	{
		int t=y1;y1=y2;y2=t;
	}
	x1=bound(cx1,x1,cx2);y1=bound(cy1,y1,cy2);
	x2=bound(cx1,x2,cx2);y2=bound(cy1,y2,cy2);
	if (x1<x2 && y1<y2)
	{
		UBYTE *d2=dst+y1*p+x1;
		x2-=x1;
		for (;y1<y2;y1++,d2+=p) memset(d2,c,x2);
	}
}

/////////////////////////////////////////// FONT

#define TABNUMSPACE 4

// Font System : NOTE - this was written pre-Lionhead and does not use Lionhead conventions - SR

const static char * new_f_names [F_NUM] =
{
	"DATA\\SmlFont.fff",
	"DATA\\MedFont.fff",
	"DATA\\LrgFont.fff"
};




// Initialisation

void AlexDC::Text8(char *t, int x, int y, int c, int colon)
{
	UBYTE *ut=(UBYTE*)t;
	int l=strlen(t);
	if (x>=cx1 && y>=cy1 && x<cx2-8 && y<cy2-8)
	{
		c^=colon;
		ULONG cc=(c)+(c<<8)+(c<<16)+(c<<24);
		ULONG co=(colon)+(colon<<8)+(colon<<16)+(colon<<24);
		__int64 cc64=(cc)+(__int64(cc)<<32);
		__int64 co64=(co)+(__int64(co)<<32);
		__int64 *d=(__int64*)(dst+x+y*p);		
		for (;*ut && x<cx2-8;ut++)
		{
			__int64 *src=font8[*ut];
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			d+=1-p;
			x+=8;
		}
	}
}

void AlexDC::Text8Side(char *t, int x, int y, int c, int colon)
{
	UBYTE *ut=(UBYTE*)t;
	int l=strlen(t);
	if (x>=cx1 && y>=cy1 && x<cx2-8 && y<cy2-8)
	{
		c^=colon;
		ULONG cc=(c)+(c<<8)+(c<<16)+(c<<24);
		ULONG co=(colon)+(colon<<8)+(colon<<16)+(colon<<24);
		__int64 cc64=(cc)+(__int64(cc)<<32);
		__int64 co64=(co)+(__int64(co)<<32);
		__int64 *d=(__int64*)(dst+x+y*p);		
		for (;*ut && y<cy2-8;ut++)
		{
			__int64 *src=font8side[*ut];
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			*d = co64 ^ (cc64 & *src++);d=(__int64*)(((char*)d)+p);
			//d+=1-p;
			y+=8;
		}
	}
}


int LoadFonts ()
{
	int loop;
#ifdef _DEMO
	Fonts[F_SML].LoadAlexData(new_f_names[F_SML]);
#else
	for (loop = 0; loop < F_NUM; loop++)
	{
		Fonts[loop].LoadAlexData((char*)new_f_names[loop]);
	}


	FILE *f=fopen("data\\hex.fnt","rb");
	if (f)
	{
		for (int c1=0;c1<256;c1++)
		{
			UBYTE t[8];
			fread(t,1,8,f);
			UBYTE *dst=(UBYTE*)(font8[c1]);
			for (int y=0;y<8;y++)
			{
				for (int x=128;x>=1;x>>=1) *dst++= (t[y]&x)? 255:0;
			}
			dst=(UBYTE*)(font8side[c1]);
			for (int x=128;x>=1;x>>=1) 
			{
				for (int y=0;y<8;y++) *dst++= (t[7-y]&x)? 255:0;
			}
		}
		fclose(f);
	}
#endif
	return 1;
}

void FreeFonts ()
{
	int loop;
#ifdef _DEMO
	loop=F_SML;
#else
	for (loop = 0; loop < F_NUM; loop++)
#endif
	{
		Fonts[loop].Free ();
	}
}


// Font


void Font::Free ()
{
	if (alexdata) delete [] alexdata;
}

void Font::Central (AlexDC *dc, char * line, int xx, int yy, ULONG col, ULONG colon)
{
	int start = (xx-Length (line)/2);
	Mess (dc, line, start, yy, col, colon);
}


void SetCol(ULONG ncol, ULONG ncolon)
{
	if (ncol!=ocol || ncolon!=ocolon)
	{
		ocolon=ncolon;
		ocol=ncol;
		for (int c1=0;c1<256;c1++)
		{		
			
			int rr = (GETR(ncol) * c1 + GETR(ncolon) * (256-c1)) >> 8;
			int gg = (GETG(ncol) * c1 + GETG(ncolon) * (256-c1)) >> 8;
			int bb = (GETB(ncol) * c1 + GETB(ncolon) * (256-c1)) >> 8;
			ctab[c1]=MAKERGB(rr,gg,bb);			
		}
	}	
}

void Font::Mess (AlexDC *dc, char * line, int l, int t, ULONG col, ULONG colon, int curpos)
{
	
	int
		len = strlen (line),
		x,
		y,
		curr,
		ch,
		thecol;

	
	if (t<dc->cy1) return;
	if (t>dc->cy2-height) return;
	int tl=Length(line);
	if (l+tl<dc->cx1 || l>=dc->cx2) return;	
	while (l<dc->cx1 && *line)
	{
		l+=CharW(*line);
		curpos--;
		line++;
	}
	len=strlen(line);
	tl=Length(line);	
	while (*line && len>0)
	{		
		if (l+tl>dc->cx2)
		{
			len--;
			tl-=CharW(line[len]);			
		}
		else break;
	}
	if (!*line || !len) return;
		
	SetCol(col,colon);	
	
	int pitch = dc->p;
	byte * line_start = (byte *) dc->dst + t * pitch;
	UBYTE *ctab = ::ctab;
	for (curr = 0; curr < len; curr++)
	{
		ch = line [curr] - FONT_LO;

		if (ch >= 0 && ch < FONT_NUM)
		{
			UBYTE * char_start = ((UBYTE *)line_start )+ (l);
			unsigned char *dataptr = alexptr[ch];
			
			int npitch = pitch-twidth[ch];

			if (curr == curpos)
			{
				thecol = ocol;
				dc->Line(l-1,t,l-1,t+height,thecol);
				
			}

			if (twidth[ch]) for (y = 0; y < height; y++)
			{
				x = twidth[ch];
				if (((int)char_start)&1) 
				{
					*char_start++ = ctab[*dataptr++];
					x--;
				}
				int odd=x&1;
				x>>=1;
				for (; x; x--)
				{
					*((unsigned short*)char_start) = ctab[dataptr[0]] + (ctab[dataptr[1]]<<8);
					char_start +=2;
					dataptr+=2;				
				}
				if (odd) *char_start++ = ctab[*dataptr++];
				
				char_start += npitch;
			}

			l += twidth[ch] + 1;
		}
		else
		{
			if (line [curr]=='\t')
			{
				l += twidth[TABCHAR-FONT_LO] * TABNUMSPACE;
			}
//			else
//			LH_ASSERT(0, "SR - Character out of bounds");
		}
	}

	if (curr == curpos)
	{
		thecol = ocol;
		dc->Line(l,t,l,t+height,thecol);		
	}
}


void Font::Mess16 (short *dstbuf, int dstpitch, int dstw, int dsth, int bits, char * line, int l, int t, ULONG col, ULONG colon, int curpos)
{
	
	int
		len = strlen (line),
		x,
		y,
		curr,	
		ch;
		
	bits=(bits+7)/16;

	int cy1=0,cx1=0,cy2=dsth,cx2=dstw;
	
	if (t<cy1) return;
	if (t>cy2-height) return;
	int tl=Length(line);
	if (l+tl<cx1 || l>=cx2) return;	
	while (l<cx1 && *line)
	{
		l+=CharW(*line);
		curpos--;
		line++;
	}
	len=strlen(line);
	tl=Length(line);	
	while (*line && len>0)
	{		
		if (l+tl>cx2)
		{
			len--;
			tl-=CharW(line[len]);			
		}
		else break;
	}
	if (!*line || !len) return;
		
	SetCol(col,colon);	
	
	int pitch = dstpitch;
	short * line_start = (short *) dstbuf + t * pitch;

	for (curr = 0; curr < len; curr++)
	{
		ch = line [curr] - FONT_LO;

		if (ch >= 0 && ch < FONT_NUM)
		{
			short * char_start = ((short *)line_start )+ (l*bits);
			unsigned char *dataptr = alexptr[ch];
			
			int npitch = pitch-twidth[ch]*bits;

			
			if (twidth[ch]) for (y = 0; y < height; y++)
			{
				x = twidth[ch];
				
				for (; x; x--)
				{
					*((unsigned short*)char_start) = pal16[ctab[dataptr[0]] ];
					char_start +=bits;
					dataptr++;				
				}
				
				char_start += npitch;
			}

			l += twidth[ch] + 1;
		}
		else
		{
			if (line [curr]=='\t')
			{
				l += twidth[TABCHAR-FONT_LO] * TABNUMSPACE;
			}
//			else
//			LH_ASSERT(0, "SR - Character out of bounds");
		}
	}

	
}


int Font::CharW(char xch)
{
	char ch = xch - FONT_LO;
	
	if (ch >= 0 && ch < FONT_NUM)
	{
		return twidth[ch] + 1;
	}
	else
	{
		if (xch=='\t')
		{
			return twidth[TABCHAR-FONT_LO] * TABNUMSPACE;
		}
	}
	return 1;
}

int Font::Length (char * line)
{
	int
		len = strlen (line),
		xx = 0,
		curr,
		ch;

	for (curr = 0; curr < len; curr++)
	{
		ch = line [curr] - FONT_LO;

		if (ch >= 0 && ch < FONT_NUM)
		{
			xx += twidth[ch] + 1;
		}
		else
		{
			if (line [curr]=='\t')
			{
				xx += twidth[TABCHAR-FONT_LO] * TABNUMSPACE;
			}
		}
	}

	return xx;
}

int get_int(FILE * fl)
{
	int i;
	fread(&i, 1, sizeof(int), fl);
	return i;
}

void write_int(FILE * fl, int val)
{
	fwrite(&val, 1, sizeof(int), fl);
}

void Font::SaveAlexData(char * pathname)
{
	FILE *fout = fopen(pathname, "wb");

	write_int(fout, width);
	write_int(fout, height);

	for (int loop=0; loop<FONT_NUM; loop++)
	{
		write_int(fout, starts[loop]);
		write_int(fout, twidth[loop]);
	}

	fwrite(alexdata, width, height, fout);

	fclose(fout);
}

void Font::LoadAlexData(char * pathname)
{

	FILE *fin = fopen(pathname, "rb");

	width = get_int(fin);
	height = get_int(fin);

	alexdata = new byte [width * height];
	byte * cur = alexdata;

	for (int loop=0; loop<FONT_NUM; loop++)
	{
		starts[loop] = get_int(fin);
		twidth[loop] = get_int(fin);

		alexptr[loop]  = cur;

		cur += twidth[loop] * height;
	}

	fread(alexdata, width, height, fin);

	fclose(fin);
	

	
}
void AlexDC::Text(char *t, int x, int y, int c, int colon, int cen)
{	
	Font *f=&Fonts[F_SML];
	y+=2;
	if(cen) f->Central(this,t,x,y,c,colon); else f->Mess(this,t,x,y,c,colon);

	}

#endif