#include "SM_SysPch.h"
#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include "MSystemFunctions.h"
#include "MVFS.h"



unsigned int MGetSystemTime()
{
	return (GetTickCount());
}

// Nombre      : MGetTempFileName()
// Parametros  : char* pcResult, char* pcFileHeader, char* pcExtension
// Retorno     : 0: OK ; -1: ERROR
// Descripcion : Consigue el nombre de un fichero temporal
int	__cdecl MGetTempFileName(char* pcResult, char* pcFileHeader, char* pcExtension)
{
	MVFSFILE* f;
	char pcName[256];
	int iNumber=0;

	strcpy(pcResult, "");

	do
	{
		sprintf(pcName, "%s%05i.%s",pcFileHeader, iNumber, pcExtension);
    f=MVFS::fopen(pcName,"rb");		
		iNumber++;

		if (f)
		{
			MVFS::fclose(f);
		}
	}
	while (f!=NULL);

	if (iNumber==100000)
	{
		return (-1);
	}

	strcpy(pcResult, pcName);
	
	return (0);
}

float fSnapTime=MSnapSystemTime();
float MSnapSystemTime()
{
  return (fSnapTime=float(MGetSystemTime())/1000.0f);
}

float GetSnapSystemTime()
{
  return (fSnapTime);
}

bool MFileExists(char* pcCompletePathFilename)
{
  MVFSFILE* f;

  if (f=MVFS::fopen(pcCompletePathFilename, "rb"))
  {
    MVFS::fclose(f);
    return(true);
  }

  return (false);
}

bool MFileExists(char* pcPath, char* pcFilename)
{
  char pcAux[256];

  strcpy(pcAux, pcPath);
  strcat(pcAux, pcFilename);

  return (MFileExists(pcAux));
}


WIN32_FIND_DATA  wfdFindData;
HANDLE           h;
bool             bSearch=false;
char             pcActualPath[256];
  

bool MStartFileFind(char* pcPath, char* pcFilter)
{
  char pcTemp[256];

  strcpy(pcActualPath, pcPath);
  strcat(pcActualPath, "/");
  
  strcpy(pcTemp, pcPath);
  strcat(pcTemp, "/");
  strcat(pcTemp, pcFilter);

  h=FindFirstFile(pcTemp, &wfdFindData);
	if (h==INVALID_HANDLE_VALUE)
	{
		return (false);
	}

  return (bSearch=true);
}

bool MGetFileCompletePath(char* pcPathFile)
{
  if (!bSearch)
  {
    FindClose(h);
    return (false);
  }

  strcpy(pcPathFile, pcActualPath);
  strcat(pcPathFile, wfdFindData.cFileName);

  if (!FindNextFile(h, &wfdFindData))
	{
		bSearch=false;
	}

  return (true);

}

bool MGetFile(char* pcPath, char* pcFile)
{
  if (!bSearch)
  {
    FindClose(h);
    return (false);
  }

  strcpy(pcPath, pcActualPath);
  strcpy(pcFile, wfdFindData.cFileName);

  if (!FindNextFile(h, &wfdFindData))
	{
		bSearch=false;
	}

  return (true);
}

void MExtractPath(char* pcPath, const char* pcPathFile)
{
  int i;
  int iLast=0;
  bool bFound=false;

  strcpy(pcPath, pcPathFile);

  for (i=0 ; pcPath[i] ; i++)
  {
    if (pcPath[i]=='/' || pcPath[i]=='\\')
    {
      bFound=true;
      iLast=i;
    }
  }

  if (bFound)
  {
    pcPath[iLast+1]=0;
  } 
  else
  {
      pcPath[0] = '\0';
  }
}

void MExtractFile(char* pcFile, const char* pcPathFile)
{
  int i;
  int iLast=0;  
  bool bFound=false;
  
  for (i=0 ; pcPathFile[i] ; i++)
  {
    if (pcPathFile[i]=='/' || pcPathFile[i]=='\\')
    {
      iLast=i;
      bFound=true;
    }
  }
  
  strcpy(pcFile, pcPathFile+iLast+(bFound?1:0));
}

void MExtractBasename(char* pcBasename, const char* pcPathFile)
{
  int      i;
  int      iPathFileLength;
  int      iExtensionStart;
  int      iLastSlash;
  bool     bFoundExtension=false;
  bool     bFoundSlash=false;

  iPathFileLength=strlen(pcPathFile);
  iLastSlash=-1;
  iExtensionStart=iPathFileLength;

  for (i=iPathFileLength ; i!=-1 ; i--)
  {
    if ((!bFoundSlash) && (!bFoundExtension) && (pcPathFile[i]=='.'))
    {
      iExtensionStart=i;
      bFoundExtension=true;
    }
    else if ((!bFoundSlash) && (pcPathFile[i]=='/' || pcPathFile[i]=='\\'))
    {
      iLastSlash=i;
      bFoundSlash=true;
    }
  }

  strncpy(pcBasename,pcPathFile+iLastSlash+1, iExtensionStart-iLastSlash-1);
  pcBasename[iExtensionStart-iLastSlash-1]='\0';
}

void MExtractPathBasename(char* pcPathBasename, char* pcPathFile)
{
  unsigned i;
  unsigned uPathFileLength;
  unsigned uExtensionStart;
  

  uPathFileLength=strlen(pcPathFile);
  uExtensionStart=uPathFileLength;

  for (i=uPathFileLength ; i!=0xFFFFFFFF ; i--)
  {
    if ((pcPathFile[i]=='.'))
    {      
      uExtensionStart=i;
      break;
    }    
  }

  strncpy(pcPathBasename,pcPathFile, uExtensionStart);
  pcPathBasename[uExtensionStart]='\0';  
}

void GenerateFullPathFileExtension(char* pcFinal, char* pcPath, char* pcFile, char* pcExtension)
{
  strcpy(pcFinal, pcPath);
  strcat(pcFinal, pcFile);
  strcat(pcFinal, pcExtension);
}

void MExtractExtension(char* pcExtension, char* pcPathFile)
{
  unsigned i;
  unsigned uPathFileLength;
  unsigned uExtensionStart;
  

  uPathFileLength=strlen(pcPathFile);
  uExtensionStart=uPathFileLength;

  for (i=uPathFileLength ; i!=0xFFFFFFFF ; i--)
  {
    if ((pcPathFile[i]=='/') || (pcPathFile[i]=='\\'))
    {
      strcpy(pcExtension,"");
      return;
    }
    if ((pcPathFile[i]=='.'))
    {      
      uExtensionStart=i;
      strcpy(pcExtension, pcPathFile+uExtensionStart+1);
      return;
    }    
  }
}



void MCleanPath(char* pcDestiny, const char* pcSource)
{
  static char pcAux[256];
  bool        b=false;
  int         i;
  int         iUsed;
  
  strcpy(pcAux, pcSource);
  _strlwr(pcAux);


  for (i=0, iUsed=0 ; pcAux[i]!='\0' ; i++)
  {
    if (pcAux[i]=='/' ||  pcAux[i]=='\\')
    {
      b=true;
    }
    else
    {
      if (b)
      {
        pcDestiny[iUsed++]='/';
        b=false;
      }
      pcDestiny[iUsed++]=pcAux[i];
    }
  }
  if (b)
  {
    pcDestiny[iUsed++]='/';
  }
  pcDestiny[iUsed++]='\0';
}

