#ifndef SMWINDOW

#define SMWINDOW

#include <windows.h>
#include "SM_Event.h"
#include "SM_EventSuscriber.h"
#include "SM_EventListener.h"

interface ILayout;


class Window : public EventListener, public EventSuscriber
{
public:
                          Window            ();   
  virtual                 ~Window           ();   
  virtual int             Init              (Window* pParent = 0);
  virtual int             Shutdown          ();  
  bool                    IsOk              ();

  // Used to dispatch the virtual call
  static LRESULT CALLBACK StaticProcessMessage
                                            (HWND hwnd, const UINT message, const WPARAM wParam, const LPARAM lParam);

  static BOOL CALLBACK  StaticProcessDialogMessage
                                            (HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

  // Aux
  void                    Show              ();
  void                    SetSize           (int w, int h);
  void                    GetSize           (int* w, int* h);
  void                    GetClientSize     (int* w, int* h);
  void                    SetPosition       (int x, int y);
  void                    GetPosition       (int* x, int* y);
  virtual void            Update            ();

  virtual int             ProcessMessage    (const UINT message, const WPARAM wParam, const LPARAM lParam);
  virtual int             ProcessDialogMessage
                                            (const UINT message, const WPARAM wParam, const LPARAM lParam);
    
  ILayout*                Layout();
  Window*                 Parent();  

  HWND                    Hwnd();

protected:
  virtual bool            IsRegistered      ();
  static int              Register          ();
  static bool             m_bRegistered;    

  // Aux
  int                     InitPrivate       (const char* pcName, DWORD dwExStyle, DWORD dwStyle, Window* pParent, const char* pcClassName = 0);
  int                     InitDialogPrivate (const char* pcName, LPCTSTR lpTemplate, Window* pParent);
  
protected:
  static Window*          g_pInitWindow;

  bool                    m_bIsOK;
  HWND                    m_hwnd;
  int                     m_iX;
  int                     m_iY;
  ILayout*                m_pLayout;
  Window*                 m_pParent;  
};



#endif

