#include "SM_Engine3DPCH.h"
#include "SM_RenderAux.h" 


int RenderAuxRadialBlur(float x, float y, float scale, int iSourceTex, int iAuxTexture[2], bool bFinalCopy, int iIterations, int iRatio)
{
  FVF_PosRhwDiffuseTex2 pVertices[4];
  unsigned short        pIndices[6]={0,2,1,0,3,2};

  float fScaleU=1.0f;
  float fScaleV=1.0f;    

  SM_D3d::Device()->SetTexture(0, ResourceManager::GetTextureFromID(iSourceTex));    
  ResourceManager::SetRenderTarget(iAuxTexture[0], -1);
  Coordinates::UpdatePhysicalSize();


  pVertices[0].x=0               -0.5f; pVertices[0].y=0                -0.5f; pVertices[0].z=0.0f; pVertices[0].u=0.0f; pVertices[0].v=0; pVertices[0].oow=1.0f; pVertices[0].diffuse=0xFFFFFFFF;
  pVertices[1].x=(float)Coordinates::PhysicalWidth()-0.5f; pVertices[1].y=0                -0.5f; pVertices[1].z=0.0f; pVertices[1].u=fScaleU; pVertices[1].v=0; pVertices[1].oow=1.0f; pVertices[1].diffuse=0xFFFFFFFF;
  pVertices[2].x=(float)Coordinates::PhysicalWidth()-0.5f; pVertices[2].y=(float)Coordinates::PhysicalHeight()-0.5f; pVertices[2].z=0.0f; pVertices[2].u=fScaleU; pVertices[2].v=fScaleV; pVertices[2].oow=1.0f; pVertices[2].diffuse=0xFFFFFFFF;
  pVertices[3].x=0               -0.5f; pVertices[3].y=(float)Coordinates::PhysicalHeight()-0.5f; pVertices[3].z=0.0f; pVertices[3].u=0.0f; pVertices[3].v=fScaleV; pVertices[3].oow=1.0f; pVertices[3].diffuse=0xFFFFFFFF;
    
  

  SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);          
  SM_D3d::SetRenderState(D3DRS_FOGENABLE, FALSE);  
  SM_D3d::SetRenderState(D3DRS_SPECULARENABLE , FALSE);
  SM_D3d::SetRenderState(D3DRS_LOCALVIEWER , FALSE);
  SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);    
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU); 
  SM_D3d::SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );           
  SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP , D3DTOP_MODULATE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
  SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAOP   , D3DTOP_SELECTARG1);
  SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAARG1 , D3DTA_DIFFUSE );
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
  SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);
  SM_D3d::SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE );    
  SM_D3d::Device()->SetVertexShader(FVF_POSRHWDIFFUSETEX2);

  SM_D3d::SetTextureStageState(1, D3DTSS_COLOROP   , D3DTOP_MULTIPLYADD);
  SM_D3d::SetTextureStageState(1, D3DTSS_COLORARG0 , D3DTA_CURRENT);
  SM_D3d::SetTextureStageState(1, D3DTSS_COLORARG1 , D3DTA_DIFFUSE);
  SM_D3d::SetTextureStageState(1, D3DTSS_COLORARG2 , D3DTA_TEXTURE);
  SM_D3d::SetTextureStageState(1, D3DTSS_ALPHAOP   , D3DTOP_SELECTARG1 );
  SM_D3d::SetTextureStageState(1, D3DTSS_ALPHAARG1 , D3DTA_DIFFUSE );
  SM_D3d::SetTextureStageState(1, D3DTSS_TEXCOORDINDEX, 1);

  //SM_D3d::SetTextureStageState(1, D3DTSS_COLOROP   , D3DTOP_SELECTARG1);
  //SM_D3d::SetTextureStageState(1, D3DTSS_ALPHAOP   , D3DTOP_DISABLE);
  
  // Do ping pong
  SM_D3d::Device()->DrawIndexedPrimitiveUP(
      D3DPT_TRIANGLELIST, 
      0,
      6,
      2,
      pIndices,
      D3DFMT_INDEX16,
      pVertices, sizeof(FVF_PosRhwDiffuseTex2));

  int iSource = 0;
  int iTarget = 0;

  // Copy to texture 0
  #define ITERATIONS 5


  for (int i = 0 ; i < iIterations ; i++)
  {
    iSource = i%2;
    iTarget = ((i+1)%2);

    SM_D3d::Device()->SetTexture(0, ResourceManager::GetTextureFromID(iAuxTexture[iSource]));
    SM_D3d::Device()->SetTexture(1, 0);
    SM_D3d::Device()->SetTexture(1, ResourceManager::GetTextureFromID(iAuxTexture[iSource]));      
    
    IDirect3DSurface8* pTextureSurface;      
    ResourceManager::GetTextureFromID(iAuxTexture[iTarget])->GetSurfaceLevel(0, &pTextureSurface);
  
    if (FAILED(SM_D3d::Device()->SetRenderTarget(
        pTextureSurface, 
        ResourceManager::GetSurfaceFromID(-1))))
    {
      return -1;
    }
    Coordinates::UpdatePhysicalSize();
    pTextureSurface->Release();

    SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        
    
    
    pVertices[0].diffuse=iRatio;
    pVertices[1].diffuse=iRatio; 
    pVertices[2].diffuse=iRatio;
    pVertices[3].diffuse=iRatio;

    pVertices[0].u = 0; pVertices[0].v = 0;
    pVertices[1].u = fScaleU; pVertices[1].v = 0;
    pVertices[2].u = fScaleU; pVertices[2].v = fScaleV;
    pVertices[3].u = 0      ; pVertices[3].v = fScaleV;

    #define OFFSET scale
    pVertices[0].s = float(i+1)*OFFSET; pVertices[0].t = float(i+1)*OFFSET;
    pVertices[1].s = fScaleU-float(i+1)*OFFSET; pVertices[1].t = float(i+1)*OFFSET;
    pVertices[2].s = fScaleU-float(i+1)*OFFSET; pVertices[2].t = fScaleV-float(i+1)*OFFSET;
    pVertices[3].s = float(i+1)*OFFSET      ; pVertices[3].t = fScaleV-float(i+1)*OFFSET;

    
    SM_D3d::Device()->DrawIndexedPrimitiveUP(
      D3DPT_TRIANGLELIST, 
      0,  
      6,
      2,
      pIndices,
      D3DFMT_INDEX16,
      pVertices, sizeof(FVF_PosRhwDiffuseTex2));                      
  }

  SM_D3d::SetTextureStageState(1, D3DTSS_COLOROP , D3DTOP_DISABLE);
  SM_D3d::SetTextureStageState(1, D3DTSS_ALPHAOP , D3DTOP_DISABLE);
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        
    
  ResourceManager::RestoreRenderTarget();
    
  if (bFinalCopy)
  {
    SM_D3d::Device()->SetTexture(0, ResourceManager::GetTextureFromID(iAuxTexture[iTarget]));    

    pVertices[0].x=0               -0.5f; pVertices[0].y=0                -0.5f;    pVertices[0].diffuse=0xFFFFFFFF;
    pVertices[1].x=(float)Coordinates::PhysicalWidth()-0.5f; pVertices[1].y=0                -0.5f;  pVertices[1].diffuse=0xFFFFFFFF;
    pVertices[2].x=(float)Coordinates::PhysicalWidth()-0.5f; pVertices[2].y=(float)Coordinates::PhysicalHeight()-0.5f;  pVertices[2].diffuse=0xFFFFFFFF;
    pVertices[3].x=0               -0.5f; pVertices[3].y=(float)Coordinates::PhysicalHeight()-0.5f; pVertices[3].z=0.0f; pVertices[3].diffuse=0xFFFFFFFF;

    SM_D3d::Device()->DrawIndexedPrimitiveUP(
        D3DPT_TRIANGLELIST, 
        0,
        6,
        2,
        pIndices,
        D3DFMT_INDEX16,
        pVertices, sizeof(FVF_PosRhwDiffuseTex2));
  }

  SM_D3d::Device()->SetTexture(1, 0);

  return iAuxTexture[iTarget];
}
